/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.orient.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.cocoapods.orient.upgrade.CocoapodsUpgrade_1_1;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class CocoapodsStoreRemoteUrlInAttributesService
extends LifecycleSupport {
    private final Path markerFile;
    private final TaskScheduler taskScheduler;

    @Inject
    public CocoapodsStoreRemoteUrlInAttributesService(ApplicationDirectories directories, TaskScheduler taskScheduler) {
        this.markerFile = new File(directories.getWorkDirectory("db"), CocoapodsUpgrade_1_1.MARKER_FILE).toPath();
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    protected void doStart() throws Exception {
        if (Files.exists(this.markerFile, new LinkOption[0])) {
            this.log.info("Scheduling task: {}", (Object)"repository.cocoapods.store-remote-url-in-attributes");
            this.taskScheduler.submit(this.taskScheduler.createTaskConfigurationInstance("repository.cocoapods.store-remote-url-in-attributes"));
        }
    }
}

