/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.internal.proxy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sonatype.nexus.repository.cocoapods.git.GitApiHelper;
import com.sonatype.nexus.repository.cocoapods.internal.PathUtils;
import com.sonatype.nexus.repository.cocoapods.internal.git.GitRepoUriParser;
import com.sonatype.nexus.repository.cocoapods.internal.proxy.InvalidSpecFileException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class SpecFileProcessor {
    private static final String POD_NAME_FIELD = "name";
    private static final String POD_VERSION_FIELD = "version";
    private static final String SOURCE_NODE_NAME = "source";
    private static final String GIT_NODE_NAME = "git";
    private static final String TAG_NODE_NAME = "tag";
    private static final String COMMIT_NODE_NAME = "commit";
    private static final String BRANCH_NODE_NAME = "branch";
    private static final String HTTP_NODE_NAME = "http";
    private static final ObjectMapper mapper = new ObjectMapper();
    private GitApiHelper gitApiHelper;

    @Inject
    public SpecFileProcessor(GitApiHelper gitApiHelper) {
        this.gitApiHelper = gitApiHelper;
    }

    public String toProxiedSpec(String specFile, URI repoUri) throws InvalidSpecFileException {
        try {
            return this.transformSpec(specFile, repoUri);
        }
        catch (IOException ioe) {
            throw new InvalidSpecFileException(specFile, ioe);
        }
    }

    public URI extractExternalUri(String specFile) throws IOException, InvalidSpecFileException {
        ObjectNode jsonSpec = (ObjectNode)mapper.readTree(specFile);
        if (!jsonSpec.has(SOURCE_NODE_NAME)) {
            throw new InvalidSpecFileException("Spec file without Source");
        }
        return this.getExternalURI(jsonSpec.get(SOURCE_NODE_NAME));
    }

    private String transformSpec(String specFile, URI repoUri) throws IOException, InvalidSpecFileException {
        ObjectNode jsonSpec = (ObjectNode)mapper.readTree(specFile);
        if (!jsonSpec.has(POD_NAME_FIELD)) {
            throw new InvalidSpecFileException("Spec file without Name");
        }
        if (!jsonSpec.has(POD_VERSION_FIELD)) {
            throw new InvalidSpecFileException("Spec file without Version");
        }
        if (!jsonSpec.has(SOURCE_NODE_NAME)) {
            throw new InvalidSpecFileException("Spec file without Source");
        }
        String name = jsonSpec.get(POD_NAME_FIELD).asText();
        String version = jsonSpec.get(POD_VERSION_FIELD).asText().trim();
        URI extDownloadUri = this.getExternalURI(jsonSpec.get(SOURCE_NODE_NAME));
        String nxrmPodUri = PathUtils.buildNxrmPodPath(name, version, extDownloadUri);
        URI sourceUri = repoUri.resolve(nxrmPodUri);
        ObjectNode sourceNode = mapper.createObjectNode();
        sourceNode.put(HTTP_NODE_NAME, sourceUri.toString());
        jsonSpec.set(SOURCE_NODE_NAME, (JsonNode)sourceNode);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonSpec);
    }

    private URI getExternalURI(JsonNode sourceNode) throws InvalidSpecFileException {
        if (sourceNode.has(GIT_NODE_NAME)) {
            String gitRepo = sourceNode.get(GIT_NODE_NAME).textValue();
            if (gitRepo == null) {
                throw new InvalidSpecFileException("null repository Uri");
            }
            URI gitRepoUri = this.parseGitRepoUri(gitRepo);
            String ref = this.extractGitRef(sourceNode);
            return this.gitApiHelper.buildDownloadURI(gitRepoUri, ref);
        }
        if (sourceNode.has(HTTP_NODE_NAME)) {
            String httpDownloadUri = sourceNode.get(HTTP_NODE_NAME).textValue();
            if (httpDownloadUri == null) {
                throw new InvalidSpecFileException("null repository Uri");
            }
            return URI.create(httpDownloadUri);
        }
        throw new InvalidSpecFileException("Invalid source: " + sourceNode.toString());
    }

    @Nullable
    private String extractGitRef(JsonNode sourceNode) {
        String[] refNodes = new String[]{COMMIT_NODE_NAME, TAG_NODE_NAME, BRANCH_NODE_NAME};
        return Arrays.stream(refNodes).map(arg_0 -> ((JsonNode)sourceNode).get(arg_0)).filter(refNode -> refNode != null && refNode.isTextual()).map(JsonNode::textValue).findFirst().orElse(null);
    }

    private URI parseGitRepoUri(String gitRepo) throws InvalidSpecFileException {
        URI gitRepoUri;
        try {
            gitRepoUri = new URI(gitRepo);
        }
        catch (URISyntaxException use) {
            throw new InvalidSpecFileException("invalid repository Uri: " + gitRepo, use);
        }
        if (gitRepoUri.getHost() == null || gitRepoUri.getPath() == null) {
            throw new InvalidSpecFileException("invalid repository Uri: " + gitRepo);
        }
        if (!GitRepoUriParser.isRepoSupported(gitRepoUri)) {
            throw new InvalidSpecFileException("Git repository not supported: " + gitRepo);
        }
        if (!GitRepoUriParser.isGitUriFormatSupported(gitRepoUri)) {
            throw new InvalidSpecFileException("invalid git repository Uri format:" + gitRepo);
        }
        return gitRepoUri;
    }
}

