/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.internal.git;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.cocoapods.internal.git.GitArtifactInfo;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.Nullable;

public class GitRepoUriParser {
    private static final String GIT_REPO_EXTENSION = ".git";
    private static final Integer VENDOR_POSITION = 1;
    private static final Integer REPO_POSITION = 2;
    private static final int GIT_PATH_SEGMENTS_COUNT = 3;

    private GitRepoUriParser() {
    }

    public static GitArtifactInfo parseGitRepoUri(URI gitRepoUri, @Nullable String ref) {
        Preconditions.checkArgument((boolean)GitRepoUriParser.isRepoSupported(gitRepoUri), (Object)("repository not supported: " + gitRepoUri));
        Preconditions.checkArgument((boolean)GitRepoUriParser.isGitUriFormatSupported(gitRepoUri), (Object)("invalid git path: " + gitRepoUri));
        String gitPath = gitRepoUri.getPath();
        if (gitPath.endsWith(GIT_REPO_EXTENSION)) {
            gitPath = gitPath.substring(0, gitPath.length() - GIT_REPO_EXTENSION.length());
        }
        String[] segments = gitPath.split("/");
        return new GitArtifactInfo(gitRepoUri.getHost(), segments[VENDOR_POSITION], GitRepoUriParser.extractRepository(segments, gitRepoUri.getHost()), ref);
    }

    private static String extractRepository(String[] segments, String host) {
        switch (host) {
            case "bitbucket.org": 
            case "github.com": {
                return segments[REPO_POSITION];
            }
            case "gitlab.com": {
                return String.join((CharSequence)"/", Arrays.copyOfRange(segments, (int)REPO_POSITION, segments.length));
            }
        }
        throw new IllegalStateException("invalid git repository: " + host);
    }

    public static boolean isGitUriFormatSupported(URI repoUri) {
        int segmentsCnt = repoUri.getPath().split("/").length;
        switch (repoUri.getHost()) {
            case "bitbucket.org": 
            case "github.com": {
                return segmentsCnt == 3;
            }
            case "gitlab.com": {
                return segmentsCnt >= 3;
            }
        }
        return false;
    }

    public static boolean isRepoSupported(URI repoUri) {
        return repoUri.getHost().equals("github.com") || repoUri.getHost().equals("bitbucket.org") || repoUri.getHost().equals("gitlab.com");
    }
}

