/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.internal;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class PathUtils {
    private static final String SPECS_PATH_FORMAT = "Specs/%s/%s/%s/%s.podspec.json";
    private static final String SPECS_SHARDS_PATH_FORMAT = "%s/%s/%s";
    private static final String API_GITHUB_HOST = "api.github.com";

    private PathUtils() {
    }

    public static String buildNxrmSpecFilePath(String name, String version) {
        return String.format(SPECS_PATH_FORMAT, PathUtils.getSpecShardPath(name), name, version, name);
    }

    public static String buildNxrmPodPath(String name, String version, URI httpDownloadUri) {
        String fileName = FilenameUtils.getName((String)httpDownloadUri.getPath());
        if (httpDownloadUri.getHost().equals(API_GITHUB_HOST)) {
            if (StringUtils.isEmpty((String)fileName)) {
                fileName = version;
            }
            fileName = String.valueOf(fileName) + ".tar.gz";
        }
        return String.format("pods/%s/%s/%s", name, version, fileName);
    }

    private static String getSpecShardPath(String name) {
        String nameHash = DigestUtils.md5Hex((byte[])name.getBytes(StandardCharsets.UTF_8));
        return String.format(SPECS_SHARDS_PATH_FORMAT, nameHash.substring(0, 1), nameHash.substring(1, 2), nameHash.substring(2, 3));
    }
}

