/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.git;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.cocoapods.internal.git.GitArtifactInfo;
import com.sonatype.nexus.repository.cocoapods.internal.git.GitRepoUriParser;
import java.net.URI;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class GitApiHelper {
    private static final String GITHUB_API_GET_REPO_SNAPSHOT_URL_TEMPLATE = "%1$s/repos/%2$s/%3$s/tarball/%4$s";
    private static final String BITBUCKET_API_GET_REPO_SNAPSHOT_URL_TEMPLATE = "%1$s/%2$s/%3$s/get/%4$s.tar.gz";
    private static final String GITLAB_API_GET_REPO_SNAPSHOT_URL_TEMPLATE = "%1$s/%2$s/%3$s/-/archive/%4$s/%4$s.tar.gz";
    private static final String DEFAULT_BRANCH = "master";
    private String githubApiUri;
    private String bitbucketApiUri;
    private String gitlabApiUri;

    @Inject
    public GitApiHelper(@Named(value="${nexus.cocoapods.gitHubApiUri:-https://api.github.com}") String githubApiUri, @Named(value="${nexus.cocoapods.bitbucketApiUri:-https://bitbucket.org}") String bitbucketApiUri, @Named(value="${nexus.cocoapods.gitlabApiUri:-https://gitlab.com}") String gitlabApiUri) {
        this.githubApiUri = (String)Preconditions.checkNotNull((Object)githubApiUri);
        this.bitbucketApiUri = (String)Preconditions.checkNotNull((Object)bitbucketApiUri);
        this.gitlabApiUri = (String)Preconditions.checkNotNull((Object)gitlabApiUri);
    }

    @VisibleForTesting
    public void setGithubApiUri(String githubApiUri) {
        this.githubApiUri = githubApiUri;
    }

    public URI buildDownloadURI(URI gitRepositoryUri, @Nullable String ref) {
        GitArtifactInfo info = GitRepoUriParser.parseGitRepoUri(gitRepositoryUri, ref);
        GitProviderConfig config = this.prepareConfig(info.getHost());
        String downloadLink = String.format(config.template, config.apiUri, info.getVendor(), info.getRepository(), info.getRef() != null ? info.getRef() : config.defaultBranch);
        return URI.create(downloadLink);
    }

    private GitProviderConfig prepareConfig(String host) {
        switch (host) {
            case "github.com": {
                return new GitProviderConfig(GITHUB_API_GET_REPO_SNAPSHOT_URL_TEMPLATE, this.githubApiUri, "");
            }
            case "bitbucket.org": {
                return new GitProviderConfig(BITBUCKET_API_GET_REPO_SNAPSHOT_URL_TEMPLATE, this.bitbucketApiUri, DEFAULT_BRANCH);
            }
            case "gitlab.com": {
                return new GitProviderConfig(GITLAB_API_GET_REPO_SNAPSHOT_URL_TEMPLATE, this.gitlabApiUri, DEFAULT_BRANCH);
            }
        }
        throw new IllegalArgumentException("invalid host: " + host);
    }

    private static class GitProviderConfig {
        String template;
        String apiUri;
        String defaultBranch;

        GitProviderConfig(String template, String apiUri, String defaultBranch) {
            this.template = template;
            this.apiUri = apiUri;
            this.defaultBranch = defaultBranch;
        }
    }
}

