/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.datastore.internal.browse;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.browse.node.BrowsePathBuilder;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.DefaultBrowseNodeGenerator;

@Singleton
@Named(value="cocoapods")
public class CocoapodsBrowseNodeGenerator
extends DefaultBrowseNodeGenerator {
    private static final String POD_PATH = "pods";

    public List<BrowsePath> computeAssetPaths(Asset asset) {
        if (asset.component().isPresent()) {
            List<BrowsePath> paths = this.computeComponentPaths(asset);
            String viewName = this.cutResourceParams(this.lastSegment(asset.path()));
            BrowsePathBuilder.appendPath(paths, (String)viewName);
            return paths;
        }
        List nameParts = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)this.cutResourceParams(asset.path()));
        return BrowsePathBuilder.fromPaths((List)nameParts, (boolean)false);
    }

    public List<BrowsePath> computeComponentPaths(Asset asset) {
        Component component = (Component)asset.component().get();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(POD_PATH);
        paths.add(component.name());
        if (!Strings2.isBlank((String)component.version())) {
            paths.add(component.version());
        }
        return BrowsePathBuilder.fromPaths(paths, (boolean)true);
    }

    private String cutResourceParams(String lastSegment) {
        int ind = lastSegment.indexOf(63);
        return ind == -1 ? lastSegment : lastSegment.substring(0, ind);
    }
}

