/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.client;

import com.sonatype.insight.scan.client.ClientScanRequest;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanSummary;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ClientScanner {
    private final Logger log;

    @Inject
    public ClientScanner() {
        this(LoggerFactory.getLogger(ClientScanner.class));
    }

    public ClientScanner(Logger log) {
        this.log = log;
    }

    public void scan(ClientScanRequest request) {
        ScanSummary summary = request.getScan().getSummary();
        ScanConfiguration config = request.getScan().getConfiguration();
        this.doScanner(summary);
        if (config.getBoolean(true, new String[]{"operatingSystem"})) {
            this.doOperatingSystem(summary);
        }
        if (config.getBoolean(true, new String[]{"procArch"})) {
            this.doProcessorArchitecture(summary);
        }
        if (config.getBoolean(true, new String[]{"ipAddresses"})) {
            this.doIpAddresses(summary);
        }
        if (config.getBoolean(true, new String[]{"jreInfo"})) {
            this.doJreInfo(summary);
        }
    }

    private InputStream getClientInfoDescriptor() {
        InputStream is = this.getClass().getResourceAsStream("/com/sonatype/insight/client.properties");
        if (is == null) {
            is = this.getClass().getResourceAsStream("/com/sonatype/insight/scan/scanner.properties");
        }
        return is;
    }

    private void doScanner(ScanSummary summary) {
        try (InputStream is = this.getClientInfoDescriptor();){
            if (is == null) {
                this.log.warn("Could not locate client info descriptor");
                return;
            }
            Properties props = new Properties();
            props.load(is);
            summary.setScannerDriver(props.getProperty("driver"));
            summary.setScannerVersion(props.getProperty("version"));
            summary.putClientInfo("insight.scannerDriver", summary.getScannerDriver());
            summary.putClientInfo("insight.scannerVersion", summary.getScannerVersion());
        }
        catch (IOException e) {
            this.log.warn("Could not read client info descriptor", (Throwable)e);
        }
    }

    private void doOperatingSystem(ScanSummary summary) {
        String name = System.getProperty("os.name");
        summary.setOperatingSystem(name);
        summary.putClientInfo("os.name", name);
    }

    private void doProcessorArchitecture(ScanSummary summary) {
        String arch = System.getProperty("os.arch");
        summary.setProcessorArchitecture(arch);
        summary.putClientInfo("os.arch", arch);
    }

    private void doIpAddresses(ScanSummary summary) {
        try {
            InetAddress local = InetAddress.getLocalHost();
            summary.setHostName(local.getHostName());
            summary.putClientInfo("network.hostName", summary.getHostName());
            StringBuilder buffer = new StringBuilder(128);
            for (InetAddress addr : InetAddress.getAllByName(local.getHostName())) {
                if (addr.isLoopbackAddress()) continue;
                summary.addIpAddress(addr.getHostAddress());
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(addr.getHostAddress());
            }
            summary.putClientInfo("network.ipAddress", buffer.toString());
        }
        catch (UnknownHostException e) {
            this.log.debug("Could not determine IP address of localhost", (Throwable)e);
        }
    }

    private void doJreInfo(ScanSummary summary) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (key.equals("java.version") || key.startsWith("java.vm.") || key.startsWith("java.vendor.") || key.startsWith("java.specification.") || key.startsWith("java.runtime.")) continue;
            it.remove();
        }
        summary.putClientInfo(props);
    }
}

