/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.orient.internal.importtask;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.RepositoryImportHelper;
import com.sonatype.nexus.exportimport.internal.importtask.ImportDeltaFileService;
import com.sonatype.nexus.exportimport.internal.importtask.ImportValidation;
import com.sonatype.nexus.exportimport.internal.importtask.RepositoryImportSource;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.common.text.UnitFormatter;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.StorageFacet;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientDiskSpaceValidation
extends ComponentSupport
implements ImportValidation {
    private final boolean enabled;
    private final ImportDeltaFileService importDeltaFileService;
    private final boolean skipArtifactoryMetadata;

    @Inject
    public OrientDiskSpaceValidation(@Named(value="${nexus.exportimport.checkDiskSpace:-true}") boolean enabled, ImportDeltaFileService importDeltaFileService, @Named(value="${nexus.import.skipartifactorymetadata:-true}") boolean skipArtifactoryMetadata) {
        this.enabled = enabled;
        this.importDeltaFileService = (ImportDeltaFileService)((Object)Preconditions.checkNotNull((Object)((Object)importDeltaFileService)));
        this.skipArtifactoryMetadata = skipArtifactoryMetadata;
    }

    @Override
    public boolean check(RepositoryImportSource source, Repository repository, boolean hardLinkEnabled) {
        if (!this.enabled || hardLinkEnabled) {
            return true;
        }
        try {
            long bytesRequired = this.totalBytesRequired(source);
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Import from {} requires {}", (Object)repository.getName(), (Object)UnitFormatter.formatStorage((long)bytesRequired));
            if (!this.repositoryHasAvailable(repository, bytesRequired)) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Destination repository {} doesn't have enough space to import content from {} ({} available, {} required)", new Object[]{repository.getName(), source, UnitFormatter.formatStorage((long)this.bytesAvailable(repository)), UnitFormatter.formatStorage((long)bytesRequired)});
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private long totalBytesRequired(RepositoryImportSource source) throws IOException {
        AtomicLong bytesRequired = new AtomicLong();
        source.walk(input -> {
            try {
                File file = input.toAbsolutePath().toFile();
                String filePath = RepositoryImportHelper.parseFilePath(file.getAbsolutePath(), source.path());
                File attributes = new File(source.path(), ".nexus/" + filePath);
                if (RepositoryImportHelper.isFileImportable(file, this.skipArtifactoryMetadata) && !this.importDeltaFileService.isAlreadyInDeltaFile(file, attributes, RepositoryImportHelper.getLastUpdatedTimestamp(file))) {
                    bytesRequired.addAndGet(file.length());
                }
                return FileVisitResult.CONTINUE;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return bytesRequired.longValue();
    }

    private boolean repositoryHasAvailable(Repository repository, long bytesRequired) {
        BlobStore blobstore = ((StorageFacet)repository.facet(StorageFacet.class)).blobStore();
        BlobStoreMetrics metrics = blobstore.getMetrics();
        return metrics.isUnlimited() || metrics.getAvailableSpace() >= bytesRequired;
    }

    private long bytesAvailable(Repository repository) {
        BlobStore blobstore = ((StorageFacet)repository.facet(StorageFacet.class)).blobStore();
        return blobstore.getMetrics().getAvailableSpace();
    }
}

