/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.importtask;

import com.sonatype.nexus.exportimport.internal.importtask.RepositoryImportTask;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.upload.UploadHandler;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;

@Named
@Singleton
public class RepositoryImportTaskDescriptor
extends TaskDescriptorSupport {
    public static final String TYPE_ID = "repository.import";
    public static final String ENABLE_HARD_LINK_FIELD_ID = "enableHardLinks";
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    @Inject
    public RepositoryImportTaskDescriptor(HostedType hostedType, NodeAccess nodeAccess, Map<String, UploadHandler> uploadHandlerMap) {
        super(TYPE_ID, RepositoryImportTask.class, messages.name(), true, true, true, new FormField[]{new RepositoryCombobox("repositoryName", messages.repositoryLabel(), messages.repositoryHelpText(), true).includingAnyOfTypes(new String[]{hostedType.getValue()}).includingAnyOfFormats(new String[]{uploadHandlerMap.entrySet().stream().filter(e -> ((UploadHandler)e.getValue()).supportsExportImport()).map(Map.Entry::getKey).collect(Collectors.joining(","))}), new StringTextFormField("sourceDir", "Source directory", "Enter directory that contains all files for import.", true), new CheckboxFormField(ENABLE_HARD_LINK_FIELD_ID, messages.hardLinkLabel(), messages.hardLinkDescription(), false), nodeAccess.isClustered() ? RepositoryImportTaskDescriptor.newLimitNodeFormField() : null});
    }

    public void initializeConfiguration(TaskConfiguration configuration) {
        configuration.setString("limitnode", "");
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository - Import external files")
        public String name();

        @MessageBundle.DefaultMessage(value="Target repository")
        public String repositoryLabel();

        @MessageBundle.DefaultMessage(value="Select the repository to import into.")
        public String repositoryHelpText();

        @MessageBundle.DefaultMessage(value="Enable Hard Links")
        public String hardLinkLabel();

        @MessageBundle.DefaultMessage(value="Use hard links to speed up the migration process. This will not move the original files. Hard links are only supported for Docker, Maven, npm, NuGet, PyPI, Raw, RubyGems and Yum repositories.")
        public String hardLinkDescription();
    }
}

