/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.importtask;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.internal.importtask.RepositoryImportService;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
public class RepositoryImportTask
extends RepositoryTaskSupport
implements Cancelable {
    public static final String TASK_DESCRIPTION = "Repository - Import external files";
    public static final String SOURCE_DIRECTORY_FIELD_ID = "sourceDir";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final RepositoryImportService repositoryImportService;
    private final HostedType hostedType;

    @Inject
    public RepositoryImportTask(RepositoryImportService repositoryImportService, HostedType hostedType) {
        this.repositoryImportService = (RepositoryImportService)Preconditions.checkNotNull((Object)repositoryImportService);
        this.hostedType = hostedType;
    }

    public String getMessage() {
        return messages.message();
    }

    protected void execute(Repository repository) {
        this.repositoryImportService.doImport(this.getConfiguration().getString(SOURCE_DIRECTORY_FIELD_ID), this.getRepositoryField(), this.getConfiguration().getBoolean("enableHardLinks", false), () -> ((RepositoryImportTask)this).isCanceled());
    }

    protected boolean appliesTo(Repository repository) {
        return this.hostedType.equals((Object)repository.getType());
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository - Import external files")
        public String message();
    }
}

