/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.importtask;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.ObjectMapperProvider;
import com.sonatype.nexus.tags.api.TagXO;
import com.sonatype.nexus.tags.service.TagService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

@Named
@Singleton
public class ImportTagsService
extends ComponentSupport {
    private final TagService tagService;
    private final ObjectMapper objectMapper;

    @Inject
    public ImportTagsService(TagService tagService, ObjectMapperProvider objectMapperProvider) {
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
        this.objectMapper = ((ObjectMapperProvider)Preconditions.checkNotNull((Object)objectMapperProvider)).get();
    }

    public void importTags(File baseDirectory) throws IOException {
        File tagsFile = new File(baseDirectory, "exported_tags.txt");
        if (tagsFile.exists()) {
            List tags = (List)this.objectMapper.readValue(tagsFile, (TypeReference)new TypeReference<List<TagXO>>(){});
            tags.forEach(tag -> {
                if (this.tagService.get(tag.getName()) == null) {
                    this.tagService.create(tag.getName(), tag.getAttributes());
                }
            });
        } else {
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "{} not found, will not import tags", (Object)tagsFile.getAbsolutePath());
        }
    }
}

