/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.sonatype.nexus.exportimport.internal.ExportImportFeature;
import com.sonatype.nexus.exportimport.internal.FilenameUtil;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportDeltaFileService;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportTagsService;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportValidation;
import com.sonatype.nexus.exportimport.internal.exporttask.InstanceDetailsExportService;
import com.sonatype.nexus.exportimport.internal.exporttask.RepositoryExportServiceSupport;
import com.sonatype.nexus.exportimport.internal.exporttask.orient.OrientExportAttributesService;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.filter.export.OrientExportAssetFilter;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientRepositoryExportService
extends RepositoryExportServiceSupport {
    private final OrientExportAttributesService exportAttributesService;
    private final ExportDeltaFileService exportDeltaFileService;
    private final AssetStore assetStore;
    private final BucketStore bucketStore;
    private final int pageSize;
    private final Map<String, OrientExportAssetFilter> exportAssetFilters;
    private final FilenameUtil filenameUtil;

    @Inject
    public OrientRepositoryExportService(LicenseFeatureVerifier licenseFeatureVerifier, ExportImportFeature exportImportFeature, OrientExportAttributesService exportAttributesService, InstanceDetailsExportService instanceDetailsExportService, RepositoryManager repositoryManager, ExportDeltaFileService exportDeltaFileService, List<ExportValidation> exportValidations, AssetStore assetStore, BucketStore bucketStore, @Named(value="${nexus.export.assetPageSize:-1000}") int pageSize, ExportTagsService exportTagsService, Map<String, OrientExportAssetFilter> exportAssetFilters, FilenameUtil filenameUtil) {
        super(licenseFeatureVerifier, exportImportFeature, repositoryManager, exportDeltaFileService, instanceDetailsExportService, exportValidations, exportTagsService);
        this.exportDeltaFileService = (ExportDeltaFileService)((Object)Preconditions.checkNotNull((Object)((Object)exportDeltaFileService)));
        this.exportAttributesService = (OrientExportAttributesService)((Object)Preconditions.checkNotNull((Object)((Object)exportAttributesService)));
        this.assetStore = (AssetStore)Preconditions.checkNotNull((Object)assetStore);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.pageSize = pageSize;
        this.exportAssetFilters = exportAssetFilters;
        this.filenameUtil = (FilenameUtil)Preconditions.checkNotNull((Object)filenameUtil);
    }

    @Override
    protected void walkAssets(Repository repository, String targetDirectory, BooleanSupplier shouldStopFunction) {
        File baseDirectory = new File(targetDirectory);
        ORID bucketId = AttachedEntityHelper.id((Entity)this.bucketStore.read(repository.getName()));
        OIndexCursor cursor = this.assetStore.getIndex(AssetEntityAdapter.I_BUCKET_COMPONENT_NAME).cursor();
        List nextPage = this.assetStore.getNextPage(cursor, this.pageSize);
        while (!Iterables.isEmpty((Iterable)nextPage)) {
            if (!this.walkPage(nextPage, repository, bucketId, baseDirectory, shouldStopFunction)) break;
            nextPage = this.assetStore.getNextPage(cursor, this.pageSize);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean walkPage(List<Map.Entry<OCompositeKey, EntityId>> page, Repository repository, ORID bucketId, File baseDirectory, BooleanSupplier shouldStopFunction) {
        var6_6 = null;
        var7_8 = null;
        try {
            storageTx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();
            try {
                storageTx.begin();
                var10_11 = page.iterator();
                while (true) {
                    indexEntry = var10_11.next();
                    if (shouldStopFunction.getAsBoolean()) {
                        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task cancelled, stopping processing");
                        return false;
                    }
                    if (!bucketId.equals(indexEntry.getKey().getKeys().get(0))) {
                        this.log.trace(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {} as it does not belong to the repository bucket", (Object)indexEntry.getValue());
                    }
                    asset = this.assetStore.getById(indexEntry.getValue());
                    if (asset == null) {
                        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping assetId {} as it was not found in the database", (Object)indexEntry.getValue());
                    }
                    validFilename = this.filenameUtil.assetNameToFilePath(asset.name());
                    target = new File(baseDirectory, validFilename);
                    if (this.exportDeltaFileService.isAlreadyInDeltaFile(target, attributes = new File(baseDirectory, ".nexus/" + validFilename), asset.lastUpdated().getMillis())) {
                        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {} as it has already been exported.", (Object)target);
                    }
                    repositoryFormat = repository.getFormat().toString();
                    exportAssetFilter = this.exportAssetFilters.get(repositoryFormat);
                    if (exportAssetFilter != null && exportAssetFilter.shouldSkipAsset(asset)) {
                        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {}.", (Object)asset.name());
                    }
                    this.exportAsset(repository, asset, target, attributes);
                    this.exportAttributesService.exportAttributes(attributes, asset, storageTx);
                    break;
                }
            }
            finally {
                if (var10_11.hasNext()) ** continue;
                return true;
            }
        }
        catch (Throwable var7_9) {
            if (var6_6 == null) {
                var6_6 = var7_9;
                throw var6_6;
            }
            if (var6_6 == var7_9) throw var6_6;
            var6_6.addSuppressed(var7_9);
            throw var6_6;
        }
    }

    private void exportAsset(Repository repository, Asset asset, File target, File attributes) {
        this.exportBlob(repository, target, attributes, asset.blobRef(), asset.name(), asset.lastUpdated());
    }

    @Override
    protected Optional<Blob> getBlob(Repository repository, BlobRef blobRef) {
        return Optional.ofNullable(((StorageFacet)repository.facet(StorageFacet.class)).blobStore().get(blobRef.getBlobId()));
    }
}

