/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask.orient;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.ObjectMapperProvider;
import com.sonatype.nexus.exportimport.model.AssetFileAttributes;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.orient.OrientTagHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
@Singleton
public class OrientExportAttributesService
extends ComponentSupport {
    private final ObjectMapper objectMapper;

    @Inject
    public OrientExportAttributesService(ObjectMapperProvider objectMapper) {
        this.objectMapper = ((ObjectMapperProvider)Preconditions.checkNotNull((Object)objectMapper)).get();
    }

    public void exportAttributes(File attributesFile, Asset asset, StorageTx tx) {
        AssetFileAttributes exportAttributes = new AssetFileAttributes();
        exportAttributes.setAssetName(asset.name());
        exportAttributes.setAssetAttributes(this.removeUnneededAttributes(asset.attributes().backing()));
        exportAttributes.setComponentTags(new ArrayList<String>());
        DateTime dateTime = asset.blobCreated();
        if (dateTime != null) {
            exportAttributes.setCreatedTimestamp(dateTime.toDate());
        }
        if ((dateTime = asset.blobUpdated()) != null) {
            exportAttributes.setLastUpdatedTimestamp(dateTime.toDate());
        }
        if ((dateTime = asset.lastDownloaded()) != null) {
            exportAttributes.setLastDownloadedTimestamp(dateTime.toDate());
        }
        if (asset.componentId() != null) {
            Component component = tx.findComponent(asset.componentId());
            if (component == null) {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Component related to the asset with EntityId {} not found", (Object)asset.componentId());
            } else {
                exportAttributes.setComponentAttributes(component.attributes().backing());
                Set tags = OrientTagHelper.getTagsFromComponent((Component)component);
                List<String> exportTags = tags.stream().map(Tag::name).collect(Collectors.toList());
                exportAttributes.setComponentTags(exportTags);
            }
        }
        try {
            Files.createDirectories(attributesFile.getParentFile().toPath(), new FileAttribute[0]);
            FileUtils.writeStringToFile((File)attributesFile, (String)this.objectMapper.writeValueAsString((Object)exportAttributes));
        }
        catch (IOException e) {
            this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Could not write properties to file {}", (Object)attributesFile.getAbsolutePath(), (Object)e);
        }
    }

    private Map<String, Object> removeUnneededAttributes(Map<String, Object> attributes) {
        attributes.remove("provenance");
        return attributes;
    }
}

