/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.internal.exporttask.DiskService;
import com.sonatype.nexus.exportimport.internal.exporttask.DiskSpaceExportValidationSupport;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportDeltaFileService;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientDiskSpaceExportValidation
extends DiskSpaceExportValidationSupport {
    private final BucketEntityAdapter bucketEntityAdapter;

    @Inject
    public OrientDiskSpaceExportValidation(@Named(value="${nexus.exportimport.checkDiskSpace:-true}") boolean enabled, BucketEntityAdapter bucketEntityAdapter, DiskService diskService, ExportDeltaFileService exportDeltaFileService) {
        super(enabled, diskService, exportDeltaFileService);
        this.bucketEntityAdapter = (BucketEntityAdapter)Preconditions.checkNotNull((Object)bucketEntityAdapter);
    }

    @Override
    protected long totalBytesRequired(String targetDirectory, Repository repository) {
        return (Long)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Iterable assets = tx.browseAssets(this.bucketEntityAdapter.read(tx.getDb(), repository.getName()));
            return StreamSupport.stream(assets.spliterator(), false).filter(asset -> !this.isAssetAlreadyExported(targetDirectory, asset.name(), asset.requireLastUpdated())).map(Asset::size).filter(Objects::nonNull).mapToLong(Long::longValue).sum();
        });
    }
}

