/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask;

import com.sonatype.nexus.exportimport.internal.exporttask.RepositoryExportTask;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.upload.UploadHandler;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;

@Named
@Singleton
public class RepositoryExportTaskDescriptor
extends TaskDescriptorSupport {
    public static final String TYPE_ID = "repository.export";
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    @Inject
    public RepositoryExportTaskDescriptor(NodeAccess nodeAccess, Map<String, UploadHandler> uploadHandlerMap, HostedType hostedType, ProxyType proxyType) {
        super(TYPE_ID, RepositoryExportTask.class, messages.name(), true, true, true, new FormField[]{new RepositoryCombobox("repositoryName", messages.repositoryLabel(), messages.repositoryHelpText(), true).includingAnyOfTypes(new String[]{hostedType.getValue(), proxyType.getValue()}).includingAnyOfFormats(new String[]{uploadHandlerMap.entrySet().stream().filter(e -> ((UploadHandler)e.getValue()).supportsExportImport()).map(Map.Entry::getKey).collect(Collectors.joining(","))}), new StringTextFormField("targetDir", messages.targetDirectoryLabel(), messages.targetDirectoryHelpText(), true), nodeAccess.isClustered() ? RepositoryExportTaskDescriptor.newLimitNodeFormField() : null});
    }

    public void initializeConfiguration(TaskConfiguration configuration) {
        configuration.setString("limitnode", "");
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository - Export assets")
        public String name();

        @MessageBundle.DefaultMessage(value="Source repository")
        public String repositoryLabel();

        @MessageBundle.DefaultMessage(value="Select the repository to export from.")
        public String repositoryHelpText();

        @MessageBundle.DefaultMessage(value="Target directory")
        public String targetDirectoryLabel();

        @MessageBundle.DefaultMessage(value="The directory to export the repository content into.")
        public String targetDirectoryHelpText();
    }
}

