/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.internal.exporttask.RepositoryExportService;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
public class RepositoryExportTask
extends RepositoryTaskSupport
implements Cancelable {
    public static final String TASK_DESCRIPTION = "Repository - Export assets";
    public static final String TARGET_DIRECTORY_FIELD_ID = "targetDir";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final RepositoryExportService repositoryExportService;
    private final HostedType hostedType;
    private final ProxyType proxyType;

    @Inject
    public RepositoryExportTask(RepositoryExportService repositoryExportService, HostedType hostedType, ProxyType proxyType) {
        this.repositoryExportService = (RepositoryExportService)Preconditions.checkNotNull((Object)repositoryExportService);
        this.hostedType = hostedType;
        this.proxyType = proxyType;
    }

    public String getMessage() {
        return messages.message();
    }

    protected void execute(Repository repository) {
        this.repositoryExportService.doExport(this.getConfiguration().getString(TARGET_DIRECTORY_FIELD_ID), this.getRepositoryField(), () -> ((RepositoryExportTask)this).isCanceled());
    }

    protected boolean appliesTo(Repository repository) {
        return this.hostedType.equals((Object)repository.getType()) || this.proxyType.equals((Object)repository.getType());
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository - Export assets")
        public String message();
    }
}

