/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.internal.ExportImportFeature;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportDeltaFileService;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportTagsService;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportValidation;
import com.sonatype.nexus.exportimport.internal.exporttask.InstanceDetailsExportService;
import com.sonatype.nexus.exportimport.internal.exporttask.RepositoryExportService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

public abstract class RepositoryExportServiceSupport
extends ComponentSupport
implements RepositoryExportService {
    private final LicenseFeatureVerifier licenseFeatureVerifier;
    private final ExportImportFeature exportImportFeature;
    private final RepositoryManager repositoryManager;
    private final ExportDeltaFileService exportDeltaFileService;
    private final InstanceDetailsExportService instanceDetailsExportService;
    private final List<ExportValidation> exportValidations;
    private final ExportTagsService exportTagsService;

    protected RepositoryExportServiceSupport(LicenseFeatureVerifier licenseFeatureVerifier, ExportImportFeature exportImportFeature, RepositoryManager repositoryManager, ExportDeltaFileService exportDeltaFileService, InstanceDetailsExportService instanceDetailsExportService, List<ExportValidation> exportValidations, ExportTagsService exportTagsService) {
        this.licenseFeatureVerifier = (LicenseFeatureVerifier)Preconditions.checkNotNull((Object)licenseFeatureVerifier);
        this.exportImportFeature = (ExportImportFeature)((Object)Preconditions.checkNotNull((Object)((Object)exportImportFeature)));
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.exportDeltaFileService = (ExportDeltaFileService)((Object)Preconditions.checkNotNull((Object)((Object)exportDeltaFileService)));
        this.instanceDetailsExportService = (InstanceDetailsExportService)((Object)Preconditions.checkNotNull((Object)((Object)instanceDetailsExportService)));
        this.exportValidations = (List)Preconditions.checkNotNull(exportValidations);
        this.exportTagsService = (ExportTagsService)((Object)Preconditions.checkNotNull((Object)((Object)exportTagsService)));
    }

    @Override
    public void doExport(String targetDirectory, String repositoryName, BooleanSupplier shouldStopFunction) {
        Repository repository = this.repositoryManager.get(repositoryName);
        try {
            if (!this.licenseFeatureVerifier.verify((Feature)this.exportImportFeature)) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository export is not licensed!");
            } else if (repository == null) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository {} not found, can't perform export.", (Object)repositoryName);
            } else {
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Checking prerequisites for export of repository {} into {}", (Object)repositoryName, (Object)targetDirectory);
                if (!this.prerequisitesMet(targetDirectory, repository)) {
                    throw new IOException("Prerequisites check failed.");
                }
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Starting export of repository {} into {}", (Object)repositoryName, (Object)targetDirectory);
                this.exportTagsService.exportTags(new File(targetDirectory, ".nexus"));
                this.walkAssets(repository, targetDirectory, shouldStopFunction);
                this.instanceDetailsExportService.exportInstanceDetails(repositoryName, String.valueOf(targetDirectory) + File.separator + ".nexus");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Export of repository %s into %s failed", repositoryName, targetDirectory), e);
        }
    }

    protected abstract void walkAssets(Repository var1, String var2, BooleanSupplier var3);

    protected void exportBlob(Repository repository, File target, File attributes, BlobRef blobRef, String assetName, DateTime lastUpdated) {
        if (blobRef != null && blobRef.getBlobId() != null) {
            Optional<Blob> blob = this.getBlob(repository, blobRef);
            if (blob.isPresent()) {
                target.getParentFile().mkdirs();
                try {
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (InputStream is = blob.get().getInputStream();){
                        Files.copy(is, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Exported asset {}", (Object)assetName);
                        this.exportDeltaFileService.appendToDeltaFile(target, attributes, lastUpdated.getMillis());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | BlobStoreException e) {
                    this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Failed to export asset {}", (Object)assetName, (Object)e);
                }
            } else {
                this.log.warn(TaskLoggingMarkers.TASK_LOG_ONLY, "Failed to export asset {}, blob {} missing.", (Object)assetName, (Object)blobRef);
            }
        }
    }

    protected abstract Optional<Blob> getBlob(Repository var1, BlobRef var2);

    private boolean prerequisitesMet(String targetDirectory, Repository repository) {
        return this.exportValidations.stream().allMatch(prereq -> prereq.check(targetDirectory, repository));
    }
}

