/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.ObjectMapperProvider;
import com.sonatype.nexus.tags.api.TagXO;
import com.sonatype.nexus.tags.service.TagService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

@Singleton
@Named
public class ExportTagsService
extends ComponentSupport {
    private static final String WRITE_ERROR = "Unable to write to tag file {}.";
    private final TagService tagService;
    private final ObjectMapper objectMapper;

    @Inject
    public ExportTagsService(TagService tagService, ObjectMapperProvider objectMapperProvider) {
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
        this.objectMapper = ((ObjectMapperProvider)Preconditions.checkNotNull((Object)objectMapperProvider)).get();
    }

    public void exportTags(File targetDirectory) {
        File tagFile = new File(targetDirectory, "exported_tags.txt");
        try {
            Files.createDirectories(tagFile.getParentFile().toPath(), new FileAttribute[0]);
            List tags = StreamSupport.stream(this.tagService.list().spliterator(), false).map(TagXO::new).collect(Collectors.toList());
            this.objectMapper.writeValue(tagFile, tags);
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, WRITE_ERROR, (Object)tagFile.getAbsolutePath(), (Object)e);
            }
            this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Unable to write to tag file {}. {}", (Object)tagFile.getAbsolutePath(), (Object)e.getMessage());
        }
    }
}

