/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.internal.exporttask.DiskService;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportDeltaFileService;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportValidation;
import java.io.File;
import java.io.IOException;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.UnitFormatter;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;

public abstract class DiskSpaceExportValidationSupport
extends ComponentSupport
implements ExportValidation {
    private final boolean enabled;
    private final DiskService diskService;
    private final ExportDeltaFileService exportDeltaFileService;

    protected DiskSpaceExportValidationSupport(boolean enabled, DiskService diskService, ExportDeltaFileService exportDeltaFileService) {
        this.enabled = enabled;
        this.diskService = (DiskService)Preconditions.checkNotNull((Object)diskService);
        this.exportDeltaFileService = (ExportDeltaFileService)((Object)Preconditions.checkNotNull((Object)((Object)exportDeltaFileService)));
    }

    @Override
    public boolean check(String targetDirectory, Repository repository) {
        if (!this.enabled) {
            return true;
        }
        try {
            long bytesRequired = this.totalBytesRequired(targetDirectory, repository);
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Export to {} requires {}", (Object)targetDirectory, (Object)UnitFormatter.formatStorage((long)bytesRequired));
            long bytesAvailable = this.diskService.availableBytes(targetDirectory);
            if (bytesAvailable < bytesRequired) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Destination {} doesn't have enough space to export content from repository {} ({} available, {} required)", new Object[]{targetDirectory, repository.getName(), UnitFormatter.formatStorage((long)bytesAvailable), UnitFormatter.formatStorage((long)bytesRequired)});
                return false;
            }
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Unable to calculate available disk space.", (Throwable)e);
            }
            this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Unable to calculate available disk space '{}'.", (Object)e.getMessage());
        }
        return true;
    }

    protected boolean isAssetAlreadyExported(String targetDirectory, String assetPath, DateTime lastUpdated) {
        File assetFile = new File(targetDirectory, assetPath);
        File attributesFile = new File(new File(targetDirectory, ".nexus"), assetPath);
        return this.exportDeltaFileService.isAlreadyInDeltaFile(assetFile, attributesFile, lastUpdated.getMillis());
    }

    protected abstract long totalBytesRequired(String var1, Repository var2);
}

