/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.DeploymentAccess;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

public class DeltaFileServiceSupport
extends ComponentSupport {
    private static final String READ_ERROR = "Unable to read delta file {}.";
    private static final String WRITE_ERROR = "Unable to write to delta file {}.";
    private static final String NEXUS_NXRM_IMPORT_EXPORT_TASK_FOLDER = "/.nexus/nxrm-import-export-task/";
    private final String deltaFileName;

    public DeltaFileServiceSupport(DeploymentAccess deploymentAccess, String fileNamePattern) {
        Preconditions.checkNotNull((Object)deploymentAccess);
        this.deltaFileName = String.format(fileNamePattern, deploymentAccess.getId());
    }

    @VisibleForTesting
    public String deltaFileName() {
        return this.deltaFileName;
    }

    protected File deltaFile(File attributesFile) {
        File oldDeltaFile = new File(attributesFile.getParentFile(), this.deltaFileName());
        if (oldDeltaFile.exists()) {
            return oldDeltaFile;
        }
        String path = attributesFile.getAbsolutePath().replace("\\", "/").replace("/.nexus/", NEXUS_NXRM_IMPORT_EXPORT_TASK_FOLDER);
        return new File(path.substring(0, path.lastIndexOf("/") + 1), this.deltaFileName);
    }

    public void appendToDeltaFile(File assetFile, File attributesFile, long timestamp) {
        File deltaFile = this.deltaFile(attributesFile);
        String fileName = assetFile.getName();
        try {
            if (!deltaFile.exists()) {
                Files.createDirectories(deltaFile.getParentFile().toPath(), new FileAttribute[0]);
                this.doAppend(fileName, timestamp, deltaFile);
            } else {
                ArrayList<String> lines = new ArrayList<String>(Files.readAllLines(deltaFile.toPath(), StandardCharsets.UTF_8));
                boolean found = false;
                int i = 0;
                while (i < lines.size()) {
                    if (((String)lines.get(i)).startsWith(String.valueOf(fileName) + "/")) {
                        String newLine = String.valueOf(fileName) + "/" + timestamp;
                        lines.set(i, newLine);
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) {
                    Files.write(deltaFile.toPath(), lines, new OpenOption[0]);
                } else {
                    this.doAppend(fileName, timestamp, deltaFile);
                }
            }
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, WRITE_ERROR, (Object)deltaFile.getAbsolutePath(), (Object)e);
            }
            this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Unable to write to delta file {}. {}", (Object)deltaFile.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    protected void doAppend(String assetName, long timestamp, File deltaFile) throws IOException {
        String line = String.valueOf(assetName) + "/" + timestamp + System.lineSeparator();
        Files.write(deltaFile.toPath(), line.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAlreadyInDeltaFile(File assetFile, File attributesFile, long timestamp) {
        File deltaFile = this.deltaFile(attributesFile);
        if (!deltaFile.exists()) return false;
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (Stream<String> lines = Files.lines(deltaFile.toPath(), StandardCharsets.UTF_8);){
                boolean bl;
                String foundLine = lines.filter(l -> l.startsWith(String.valueOf(assetFile.getName()) + "/")).findFirst().orElse(null);
                if (foundLine == null) {
                    return false;
                }
                long lastTimestamp = Long.parseLong(foundLine.substring(foundLine.indexOf(47) + 1));
                if (lastTimestamp == timestamp) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, READ_ERROR, (Object)deltaFile.getAbsolutePath(), (Object)e);
                return false;
            }
            this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Unable to read delta file {}. {}", (Object)deltaFile.getAbsolutePath(), (Object)e.getMessage());
        }
        return false;
    }
}

