/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.datastore.internal.importtask;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.RepositoryImportHelper;
import com.sonatype.nexus.exportimport.datastore.ImportAttributesService;
import com.sonatype.nexus.exportimport.internal.ExportImportFeature;
import com.sonatype.nexus.exportimport.internal.FilenameUtil;
import com.sonatype.nexus.exportimport.internal.importtask.ImportDeltaFileService;
import com.sonatype.nexus.exportimport.internal.importtask.ImportTagsService;
import com.sonatype.nexus.exportimport.internal.importtask.ImportValidation;
import com.sonatype.nexus.exportimport.internal.importtask.RepositoryImportService;
import com.sonatype.nexus.exportimport.internal.importtask.RepositoryImportSource;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.repository.view.Content;

@Named
public class RepositoryImportServiceImpl
extends ComponentSupport
implements RepositoryImportService {
    private final UploadManager uploadManager;
    private final LicenseFeatureVerifier licenseFeatureVerifier;
    private final ExportImportFeature exportImportFeature;
    private final RepositoryManager repositoryManager;
    private final ImportDeltaFileService importDeltaFileService;
    private final List<ImportValidation> importValidations;
    private final ImportAttributesService importAttributesService;
    private final ImportTagsService importTagsService;
    private final FilenameUtil filenameUtil;
    private final boolean skipArtifactoryMetadata;

    @Inject
    public RepositoryImportServiceImpl(UploadManager uploadManager, ExportImportFeature exportImportFeature, LicenseFeatureVerifier licenseFeatureVerifier, RepositoryManager repositoryManager, ImportDeltaFileService importDeltaFileService, ImportAttributesService importAttributesService, List<ImportValidation> importValidations, ImportTagsService importTagsService, FilenameUtil filenameUtil, @Named(value="${nexus.import.skipartifactorymetadata:-true}") boolean skipArtifactoryMetadata) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.uploadManager = (UploadManager)Preconditions.checkNotNull((Object)uploadManager);
        this.exportImportFeature = (ExportImportFeature)((Object)Preconditions.checkNotNull((Object)((Object)exportImportFeature)));
        this.licenseFeatureVerifier = (LicenseFeatureVerifier)Preconditions.checkNotNull((Object)licenseFeatureVerifier);
        this.importDeltaFileService = (ImportDeltaFileService)((Object)Preconditions.checkNotNull((Object)((Object)importDeltaFileService)));
        this.importAttributesService = (ImportAttributesService)((Object)Preconditions.checkNotNull((Object)((Object)importAttributesService)));
        this.importValidations = (List)Preconditions.checkNotNull(importValidations);
        this.importTagsService = (ImportTagsService)((Object)Preconditions.checkNotNull((Object)((Object)importTagsService)));
        this.filenameUtil = (FilenameUtil)Preconditions.checkNotNull((Object)filenameUtil);
        this.skipArtifactoryMetadata = skipArtifactoryMetadata;
    }

    @Override
    public void doImport(String sourceDirectory, String repositoryName, boolean hardLinkEnabled, BooleanSupplier shouldStopFunction) {
        Repository repository = this.repositoryManager.get(repositoryName);
        try {
            if (!this.licenseFeatureVerifier.verify((Feature)this.exportImportFeature)) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository import is not licensed!");
            } else if (repository == null) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository {} not found, can't perform import.", (Object)repositoryName);
            } else {
                RepositoryImportSource source = new RepositoryImportSource(sourceDirectory);
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Checking prerequisites for import of {} into repository {}", (Object)source, (Object)repositoryName);
                if (this.prerequisitesMet(source, repository, hardLinkEnabled)) {
                    this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Import tags from export");
                    this.importTagsService.importTags(new File(sourceDirectory, ".nexus"));
                    this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Starting import of {} into repository {}", (Object)source, (Object)repositoryName);
                    this.walkImportDirectory(source, repository, hardLinkEnabled, shouldStopFunction);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Import of %s into repository %s failed", sourceDirectory, repositoryName), e);
        }
    }

    private void walkImportDirectory(RepositoryImportSource source, Repository repository, boolean hardLinkEnabled, BooleanSupplier shouldStopFunction) throws IOException {
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        source.walk(input -> {
            if (shouldStopFunction.getAsBoolean()) {
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task cancelled, stopping processing");
                return FileVisitResult.TERMINATE;
            }
            File file = input.toAbsolutePath().toFile();
            String filePath = RepositoryImportHelper.parseFilePath(file.getAbsolutePath(), source.path());
            File attributes = new File(source.path(), ".nexus/" + filePath);
            String assetPath = this.filenameUtil.filePathToAssetName(filePath);
            if (assetPath.charAt(0) != '/') {
                assetPath = String.valueOf('/') + assetPath;
            }
            try {
                if (!RepositoryImportHelper.isFileImportable(file, this.skipArtifactoryMetadata)) {
                    this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {} because it is either a configuration file, a hidden file or a directory.", (Object)file.getAbsolutePath());
                    return FileVisitResult.CONTINUE;
                }
                if (this.importDeltaFileService.isAlreadyInDeltaFile(file, attributes, RepositoryImportHelper.getLastUpdatedTimestamp(file))) {
                    this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {} as it has already been imported.", (Object)file.getAbsolutePath());
                    return FileVisitResult.CONTINUE;
                }
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Importing {}", (Object)file.getAbsolutePath());
                try {
                    Throwable throwable = null;
                    Object var12_15 = null;
                    try (Content content = this.uploadManager.handle(new ImportFileConfiguration(repository, file, assetPath, hardLinkEnabled));){
                        contentFacet.assets().path(assetPath).find().ifPresent(asset -> this.importAttributesService.importAttributes(source.path(), file, (Asset)asset, repository));
                        this.importDeltaFileService.appendToDeltaFile(file, attributes, RepositoryImportHelper.getLastUpdatedTimestamp(file));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Import of file {} into repository {} failed", new Object[]{file, repository.getName(), e});
                }
            }
            catch (Exception e) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Import of file {} into repository {} failed", new Object[]{file, repository.getName(), e});
            }
            return FileVisitResult.CONTINUE;
        });
    }

    private boolean prerequisitesMet(RepositoryImportSource source, Repository repository, boolean hardLinkEnabled) {
        return this.importValidations.stream().allMatch(prereq -> prereq.check(source, repository, hardLinkEnabled));
    }
}

