/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.datastore.internal.importtask;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.sonatype.nexus.exportimport.RepositoryImportHelper;
import com.sonatype.nexus.exportimport.internal.importtask.ImportValidation;
import com.sonatype.nexus.exportimport.internal.importtask.RepositoryImportSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;

@Named
@Singleton
public class HardLinksValidation
extends ComponentSupport
implements ImportValidation {
    private final BlobStoreManager blobStoreManager;
    private final boolean skipArtifactoryMetadata;

    @Inject
    public HardLinksValidation(BlobStoreManager blobStoreManager, @Named(value="${nexus.import.skipartifactorymetadata:-true}") boolean skipArtifactoryMetadata) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.skipArtifactoryMetadata = skipArtifactoryMetadata;
    }

    @Override
    public boolean check(RepositoryImportSource source, Repository repository, boolean hardLinkEnabled) {
        if (!hardLinkEnabled) {
            return true;
        }
        try {
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Import from {} requires hard links", (Object)repository.getName());
            if (!this.repositorySupportsHardLinks(source, repository)) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Destination repository {} cannot use hard links to import content from {}", (Object)repository.getName(), (Object)source);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean repositorySupportsHardLinks(RepositoryImportSource source, Repository repository) throws IOException {
        AtomicBoolean hardLinksSupported = new AtomicBoolean(true);
        source.walk(input -> {
            if (!RepositoryImportHelper.isFileImportable(input.toFile(), this.skipArtifactoryMetadata)) {
                return FileVisitResult.CONTINUE;
            }
            try {
                byte[] bytes = Files.readAllBytes(input);
                String blobStoreName = (String)((Map)repository.getConfiguration().getAttributes().get("storage")).get("blobStoreName");
                BlobStore blobStore = this.blobStoreManager.get(blobStoreName);
                Blob blob = blobStore.create(input, (Map)ImmutableMap.of((Object)"BlobStore.blob-name", (Object)input.toString(), (Object)"BlobStore.created-by", (Object)"system"), (long)bytes.length, Hashing.sha1().hashBytes(bytes));
                blobStore.deleteHard(blob.getId());
            }
            catch (BlobStoreException e) {
                hardLinksSupported.set(false);
                this.log.debug("Unable to create hard link to {}", input, (Object)e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return FileVisitResult.TERMINATE;
        });
        return hardLinksSupported.get();
    }
}

