/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.datastore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.ObjectMapperProvider;
import com.sonatype.nexus.exportimport.RepositoryImportHelper;
import com.sonatype.nexus.exportimport.model.AssetFileAttributes;
import com.sonatype.nexus.exportimport.model.AssetFileAttributesNX2;
import com.sonatype.nexus.tags.service.TagService;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.importtask.ImportPostProcessor;
import org.sonatype.nexus.repository.content.store.InternalIds;

@Named
@Singleton
public class ImportAttributesService
extends ComponentSupport {
    private final ObjectMapper objectMapper;
    private final TagService tagService;
    private final Map<String, ImportPostProcessor> importAdditionalAttributeProcessors;

    @Inject
    public ImportAttributesService(TagService tagService, ObjectMapperProvider objectMapperProvider, Map<String, ImportPostProcessor> importAdditionalAttributeProcessors) {
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
        this.importAdditionalAttributeProcessors = (Map)Preconditions.checkNotNull(importAdditionalAttributeProcessors);
        this.objectMapper = ((ObjectMapperProvider)Preconditions.checkNotNull((Object)objectMapperProvider)).get();
    }

    public void importAttributes(AssetFileAttributes importFileAttributesNx3, AssetFileAttributesNX2 importFileAttributesNx2, Asset asset, Repository repository) {
        FluentAsset fluentAsset = ((ContentFacet)repository.facet(ContentFacet.class)).assets().with(asset);
        if (importFileAttributesNx2 != null) {
            this.updateAsset(importFileAttributesNx2, fluentAsset);
        } else if (importFileAttributesNx3 != null) {
            this.updateAssetAndComponent(importFileAttributesNx3, fluentAsset, repository);
        }
        ImportPostProcessor importPostProcessor = this.importAdditionalAttributeProcessors.get(repository.getFormat().toString());
        if (importPostProcessor != null) {
            importPostProcessor.attributePostProcessing(repository, asset);
        }
    }

    public void importAttributes(String sourceDirectory, File currentUpload, Asset asset, Repository repository) {
        String validSourceDirectory = sourceDirectory.endsWith(File.separator) ? sourceDirectory : String.valueOf(sourceDirectory) + File.separator;
        AssetFileAttributesNX2 importFileAttributesNx2 = this.getImportFileAttributesNx2(currentUpload, validSourceDirectory);
        AssetFileAttributes importFileAttributesNx3 = this.getImportFileAttributesNx3(currentUpload, validSourceDirectory);
        this.importAttributes(importFileAttributesNx3, importFileAttributesNx2, asset, repository);
    }

    private AssetFileAttributes getImportFileAttributesNx3(File file, String sourceDirectory) {
        File attributesFile = new File(RepositoryImportHelper.toAttributePath(file.getAbsolutePath(), sourceDirectory));
        if (attributesFile.exists()) {
            try {
                return (AssetFileAttributes)this.objectMapper.readValue(attributesFile, AssetFileAttributes.class);
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "error reading NXRM 3 attributes file {}", (Object)attributesFile.getAbsolutePath(), (Object)e);
                }
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "error reading NXRM 3 attributes file {}: {}", (Object)attributesFile.getAbsolutePath(), (Object)e.getMessage());
            }
        }
        return null;
    }

    private AssetFileAttributesNX2 getImportFileAttributesNx2(File file, String sourceDirectory) {
        File attributesFile = new File(RepositoryImportHelper.toNxrm2AttributePath(file.getAbsolutePath(), sourceDirectory));
        if (attributesFile.exists()) {
            try {
                return (AssetFileAttributesNX2)this.objectMapper.readValue(attributesFile, AssetFileAttributesNX2.class);
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "error reading NXRM 2 attributes file {}", (Object)attributesFile.getAbsolutePath(), (Object)e);
                }
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "error reading NXRM 2 attributes file {}: {}", (Object)attributesFile.getAbsolutePath(), (Object)e.getMessage());
            }
        }
        return null;
    }

    private void updateAsset(AssetFileAttributesNX2 importFileAttributesNX2, FluentAsset asset) {
        if (importFileAttributesNX2.getCreated() != null) {
            asset.created(this.toOffsetDateTime(importFileAttributesNX2.getCreated()));
        }
        if (importFileAttributesNX2.getModified() != null) {
            asset.blobCreated(this.toOffsetDateTime(importFileAttributesNX2.getModified()));
        }
        if (importFileAttributesNX2.getLastRequested() != null) {
            asset.lastDownloaded(this.toOffsetDateTime(importFileAttributesNX2.getLastRequested()));
        }
    }

    protected void updateAssetAndComponent(AssetFileAttributes importFileAttributes, FluentAsset asset, Repository repository) {
        Optional assetComponent;
        if (importFileAttributes.getCreatedTimestamp() != null) {
            asset.created(this.toOffsetDateTime(importFileAttributes.getCreatedTimestamp()));
        }
        if (importFileAttributes.getLastUpdatedTimestamp() != null) {
            asset.blobCreated(this.toOffsetDateTime(importFileAttributes.getLastUpdatedTimestamp()));
        }
        if (importFileAttributes.getLastDownloadedTimestamp() != null) {
            asset.lastDownloaded(this.toOffsetDateTime(importFileAttributes.getLastDownloadedTimestamp()));
        }
        if ((assetComponent = asset.component()).isPresent()) {
            Component component = (Component)assetComponent.get();
            List<String> componentTags = importFileAttributes.getComponentTags();
            if (componentTags != null) {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Found {} tags associated to component {}", (Object)componentTags.size(), (Object)component);
                componentTags.forEach(tag -> {
                    if (this.tagService.get(tag) == null) {
                        this.log.error("{} is assigned a tag that is not yet created {}, skipping assignment", (Object)importFileAttributes.getAssetName(), tag);
                    } else {
                        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Found tag {}, associating to component {}", tag, (Object)component);
                        this.tagService.associateById(tag, repository, InternalIds.toExternalId((int)InternalIds.internalComponentId((Component)component)));
                    }
                });
            } else {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Not applying component tag associations for this asset, they could not be located.");
            }
        } else {
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Asset {} did not have a componentId", (Object)asset.path());
        }
    }

    private OffsetDateTime toOffsetDateTime(Date date) {
        return OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
    }

    private OffsetDateTime toOffsetDateTime(Long date) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(date), ZoneOffset.UTC);
    }
}

