/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zz.org.sonatype.aether.repository.MirrorSelector;
import zz.org.sonatype.aether.repository.RemoteRepository;

public class DefaultMirrorSelector
implements MirrorSelector {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private final List<MirrorDef> mirrors = new ArrayList<MirrorDef>();

    public DefaultMirrorSelector add(String id, String url, String type, boolean repositoryManager, String mirrorOfIds, String mirrorOfTypes) {
        this.mirrors.add(new MirrorDef(id, url, type, repositoryManager, mirrorOfIds, mirrorOfTypes));
        return this;
    }

    public RemoteRepository getMirror(RemoteRepository repository) {
        MirrorDef mirror = this.findMirror(repository);
        if (mirror == null) {
            return null;
        }
        RemoteRepository repo = new RemoteRepository();
        repo.setRepositoryManager(mirror.repositoryManager);
        repo.setId(mirror.id);
        repo.setUrl(mirror.url);
        if (mirror.type != null && mirror.type.length() > 0) {
            repo.setContentType(mirror.type);
        } else {
            repo.setContentType(repository.getContentType());
        }
        repo.setPolicy(true, repository.getPolicy(true));
        repo.setPolicy(false, repository.getPolicy(false));
        repo.setMirroredRepositories(Collections.singletonList(repository));
        return repo;
    }

    private MirrorDef findMirror(RemoteRepository repository) {
        String repoId = repository.getId();
        if (repoId != null && !this.mirrors.isEmpty()) {
            for (MirrorDef mirror : this.mirrors) {
                if (!repoId.equals(mirror.mirrorOfIds) || !DefaultMirrorSelector.matchesType(repository.getContentType(), mirror.mirrorOfTypes)) continue;
                return mirror;
            }
            for (MirrorDef mirror : this.mirrors) {
                if (!DefaultMirrorSelector.matchPattern(repository, mirror.mirrorOfIds) || !DefaultMirrorSelector.matchesType(repository.getContentType(), mirror.mirrorOfTypes)) continue;
                return mirror;
            }
        }
        return null;
    }

    static boolean matchPattern(RemoteRepository repository, String pattern) {
        boolean result = false;
        String originalId = repository.getId();
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split(",")) {
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!repo.substring(1).equals(originalId)) continue;
                    result = false;
                    break;
                }
                if (repo.equals(originalId)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && DefaultMirrorSelector.isExternalRepo(repository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    static boolean isExternalRepo(RemoteRepository repository) {
        boolean local = "localhost".equals(repository.getHost()) || "127.0.0.1".equals(repository.getHost()) || "file".equalsIgnoreCase(repository.getProtocol());
        return !local;
    }

    static boolean matchesType(String repoType, String mirrorType) {
        boolean result = false;
        if (mirrorType == null || mirrorType.length() <= 0 || WILDCARD.equals(mirrorType)) {
            result = true;
        } else if (mirrorType.equals(repoType)) {
            result = true;
        } else {
            String[] layouts;
            for (String layout : layouts = mirrorType.split(",")) {
                if (layout.length() > 1 && layout.startsWith("!")) {
                    if (!layout.substring(1).equals(repoType)) continue;
                    result = false;
                    break;
                }
                if (layout.equals(repoType)) {
                    result = true;
                    break;
                }
                if (!WILDCARD.equals(layout)) continue;
                result = true;
            }
        }
        return result;
    }

    static class MirrorDef {
        final String id;
        final String url;
        final String type;
        final boolean repositoryManager;
        final String mirrorOfIds;
        final String mirrorOfTypes;

        public MirrorDef(String id, String url, String type, boolean repositoryManager, String mirrorOfIds, String mirrorOfTypes) {
            this.id = id;
            this.url = url;
            this.type = type;
            this.repositoryManager = repositoryManager;
            this.mirrorOfIds = mirrorOfIds;
            this.mirrorOfTypes = mirrorOfTypes;
        }
    }
}

