/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import zz.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import zz.org.eclipse.jgit.errors.MissingObjectException;
import zz.org.eclipse.jgit.treewalk.TreeWalk;
import zz.org.eclipse.jgit.treewalk.WorkingTreeIterator;
import zz.org.eclipse.jgit.treewalk.filter.TreeFilter;

public class NotIgnoredFilter
extends TreeFilter {
    private final int index;

    public NotIgnoredFilter(int workdirTreeIndex) {
        this.index = workdirTreeIndex;
    }

    @Override
    public boolean include(TreeWalk tw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        WorkingTreeIterator i = tw.getTree(this.index, WorkingTreeIterator.class);
        return i == null || !i.isEntryIgnored();
    }

    @Override
    public boolean shouldBeRecursive() {
        return false;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "NotIgnored(" + this.index + ")";
    }
}

