/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.transport;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import zz.org.eclipse.jgit.errors.TransportException;
import zz.org.eclipse.jgit.internal.JGitText;
import zz.org.eclipse.jgit.internal.storage.pack.PackWriter;
import zz.org.eclipse.jgit.lib.AnyObjectId;
import zz.org.eclipse.jgit.lib.Constants;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.lib.ObjectIdRef;
import zz.org.eclipse.jgit.lib.ProgressMonitor;
import zz.org.eclipse.jgit.lib.Ref;
import zz.org.eclipse.jgit.lib.RefWriter;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.transport.BaseConnection;
import zz.org.eclipse.jgit.transport.PushConnection;
import zz.org.eclipse.jgit.transport.RemoteRefUpdate;
import zz.org.eclipse.jgit.transport.Transport;
import zz.org.eclipse.jgit.transport.URIish;
import zz.org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import zz.org.eclipse.jgit.transport.WalkTransport;

class WalkPushConnection
extends BaseConnection
implements PushConnection {
    private final Repository local;
    private final URIish uri;
    final WalkRemoteObjectDatabase dest;
    private final Transport transport;
    private LinkedHashMap<String, String> packNames;
    private Map<String, Ref> newRefs;
    private Collection<RemoteRefUpdate> packedRefUpdates;

    WalkPushConnection(WalkTransport walkTransport, WalkRemoteObjectDatabase w) {
        this.transport = (Transport)((Object)walkTransport);
        this.local = this.transport.local;
        this.uri = this.transport.getURI();
        this.dest = w;
    }

    @Override
    public void push(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates) throws TransportException {
        this.push(monitor, refUpdates, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void push(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates, OutputStream out) throws TransportException {
        block13: {
            this.markStartedOperation();
            this.packNames = null;
            this.newRefs = new TreeMap<String, Ref>(this.getRefsMap());
            this.packedRefUpdates = new ArrayList<RemoteRefUpdate>(refUpdates.size());
            updates = new ArrayList<RemoteRefUpdate>();
            for (RemoteRefUpdate u : refUpdates.values()) {
                n = u.getRemoteName();
                if (!n.startsWith("refs/") || !Repository.isValidRefName(n)) {
                    u.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
                    u.setMessage(JGitText.get().funnyRefname);
                    continue;
                }
                if (AnyObjectId.isEqual(ObjectId.zeroId(), u.getNewObjectId())) {
                    this.deleteCommand(u);
                    continue;
                }
                updates.add(u);
            }
            if (!updates.isEmpty()) {
                this.sendpack(updates, monitor);
            }
            for (RemoteRefUpdate u : updates) {
                this.updateCommand(u);
            }
            if (!updates.isEmpty() && this.isNewRepository()) {
                this.createNewRepository(updates);
            }
            refWriter = new RefWriter(this.newRefs.values()){

                @Override
                protected void writeFile(String file, byte[] content) throws IOException {
                    WalkPushConnection.this.dest.writeFile("../" + file, content);
                }
            };
            if (!this.packedRefUpdates.isEmpty()) {
                try {
                    refWriter.writePackedRefs();
                    for (RemoteRefUpdate u : this.packedRefUpdates) {
                        u.setStatus(RemoteRefUpdate.Status.OK);
                    }
                    break block13;
                }
                catch (IOException err) {
                    ** for (u : this.packedRefUpdates)
                }
lbl-1000:
                // 1 sources

                {
                    u.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
                    u.setMessage(err.getMessage());
                    continue;
                }
lbl38:
                // 1 sources

                throw new TransportException(this.uri, JGitText.get().failedUpdatingRefs, err);
            }
        }
        try {
            refWriter.writeInfoRefs();
        }
        catch (IOException err) {
            throw new TransportException(this.uri, JGitText.get().failedUpdatingRefs, err);
        }
    }

    @Override
    public void close() {
        this.dest.close();
    }

    private void sendpack(List<RemoteRefUpdate> updates, ProgressMonitor monitor) throws TransportException {
        String pathPack = null;
        String pathIdx = null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PackWriter writer = new PackWriter(this.transport.getPackConfig(), this.local.newObjectReader());){
                BufferedOutputStream os;
                HashSet<ObjectId> need = new HashSet<ObjectId>();
                HashSet<ObjectId> have = new HashSet<ObjectId>();
                for (RemoteRefUpdate remoteRefUpdate : updates) {
                    need.add(remoteRefUpdate.getNewObjectId());
                }
                for (Ref ref : this.getRefs()) {
                    have.add(ref.getObjectId());
                    if (ref.getPeeledObjectId() == null) continue;
                    have.add(ref.getPeeledObjectId());
                }
                writer.preparePack(monitor, need, have);
                if (writer.getObjectCount() == 0L) {
                    return;
                }
                this.packNames = new LinkedHashMap();
                for (String string : this.dest.getPackNames()) {
                    this.packNames.put(string, string);
                }
                String string = "pack-" + writer.computeName().name();
                String packName = String.valueOf(string) + ".pack";
                pathPack = "pack/" + packName;
                pathIdx = "pack/" + string + ".idx";
                if (this.packNames.remove(packName) != null) {
                    this.dest.writeInfoPacks(this.packNames.keySet());
                    this.dest.deleteFile(pathIdx);
                }
                String wt = "Put " + string.substring(0, 12);
                Throwable throwable2 = null;
                Object var14_24 = null;
                try {
                    os = new BufferedOutputStream(this.dest.writeFile(pathPack, monitor, String.valueOf(wt) + "..pack"));
                    try {
                        writer.writePack(monitor, monitor, os);
                    }
                    finally {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                throwable2 = null;
                var14_24 = null;
                try {
                    os = new BufferedOutputStream(this.dest.writeFile(pathIdx, monitor, String.valueOf(wt) + "..idx"));
                    try {
                        writer.writeIndex(os);
                    }
                    finally {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                ArrayList<String> infoPacks = new ArrayList<String>();
                infoPacks.add(packName);
                infoPacks.addAll(this.packNames.keySet());
                this.dest.writeInfoPacks(infoPacks);
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException err) {
            this.safeDelete(pathIdx);
            this.safeDelete(pathPack);
            throw new TransportException(this.uri, JGitText.get().cannotStoreObjects, err);
        }
    }

    private void safeDelete(String path) {
        if (path != null) {
            try {
                this.dest.deleteFile(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteCommand(RemoteRefUpdate u) {
        Ref r = this.newRefs.remove(u.getRemoteName());
        if (r == null) {
            u.setStatus(RemoteRefUpdate.Status.OK);
            return;
        }
        if (r.getStorage().isPacked()) {
            this.packedRefUpdates.add(u);
        }
        if (r.getStorage().isLoose()) {
            try {
                this.dest.deleteRef(u.getRemoteName());
                u.setStatus(RemoteRefUpdate.Status.OK);
            }
            catch (IOException e) {
                u.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
                u.setMessage(e.getMessage());
            }
        }
        try {
            this.dest.deleteRefLog(u.getRemoteName());
        }
        catch (IOException e) {
            u.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            u.setMessage(e.getMessage());
        }
    }

    private void updateCommand(RemoteRefUpdate u) {
        try {
            this.dest.writeRef(u.getRemoteName(), u.getNewObjectId());
            this.newRefs.put(u.getRemoteName(), new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, u.getRemoteName(), u.getNewObjectId()));
            u.setStatus(RemoteRefUpdate.Status.OK);
        }
        catch (IOException e) {
            u.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            u.setMessage(e.getMessage());
        }
    }

    private boolean isNewRepository() {
        return this.getRefsMap().isEmpty() && this.packNames != null && this.packNames.isEmpty();
    }

    private void createNewRepository(List<RemoteRefUpdate> updates) throws TransportException {
        byte[] bytes;
        try {
            String ref = "ref: " + WalkPushConnection.pickHEAD(updates) + "\n";
            bytes = Constants.encode(ref);
            this.dest.writeFile("../HEAD", bytes);
        }
        catch (IOException e) {
            throw new TransportException(this.uri, JGitText.get().cannotCreateHEAD, e);
        }
        try {
            String config = "[core]\n\trepositoryformatversion = 0\n";
            bytes = Constants.encode("[core]\n\trepositoryformatversion = 0\n");
            this.dest.writeFile("../config", bytes);
        }
        catch (IOException e) {
            throw new TransportException(this.uri, JGitText.get().cannotCreateConfig, e);
        }
    }

    private static String pickHEAD(List<RemoteRefUpdate> updates) {
        String n;
        for (RemoteRefUpdate u : updates) {
            n = u.getRemoteName();
            if (!n.equals("refs/heads/master")) continue;
            return n;
        }
        for (RemoteRefUpdate u : updates) {
            n = u.getRemoteName();
            if (!n.startsWith("refs/heads/")) continue;
            return n;
        }
        return updates.get(0).getRemoteName();
    }
}

