/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.lib;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import zz.org.eclipse.jgit.lib.ProgressMonitor;

public class ThreadSafeProgressMonitor
implements ProgressMonitor {
    private final ProgressMonitor pm;
    private final ReentrantLock lock;
    private final Thread mainThread;
    private final AtomicInteger workers;
    private final AtomicInteger pendingUpdates;
    private final Semaphore process;

    public ThreadSafeProgressMonitor(ProgressMonitor pm) {
        this.pm = pm;
        this.lock = new ReentrantLock();
        this.mainThread = Thread.currentThread();
        this.workers = new AtomicInteger(0);
        this.pendingUpdates = new AtomicInteger(0);
        this.process = new Semaphore(0);
    }

    @Override
    public void start(int totalTasks) {
        if (!this.isMainThread()) {
            throw new IllegalStateException();
        }
        this.pm.start(totalTasks);
    }

    @Override
    public void beginTask(String title, int totalWork) {
        if (!this.isMainThread()) {
            throw new IllegalStateException();
        }
        this.pm.beginTask(title, totalWork);
    }

    public void startWorker() {
        this.startWorkers(1);
    }

    public void startWorkers(int count) {
        this.workers.addAndGet(count);
    }

    public void endWorker() {
        if (this.workers.decrementAndGet() == 0) {
            this.process.release();
        }
    }

    public void pollForUpdates() {
        assert (this.isMainThread());
        this.doUpdates();
    }

    /*
     * Unable to fully structure code
     */
    public void waitForCompletion() throws InterruptedException {
        if (ThreadSafeProgressMonitor.$assertionsDisabled || this.isMainThread()) ** GOTO lbl5
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.doUpdates();
            this.process.acquire();
lbl5:
            // 2 sources

            ** while (this.workers.get() > 0)
        }
lbl6:
        // 1 sources

        this.doUpdates();
    }

    private void doUpdates() {
        int cnt = this.pendingUpdates.getAndSet(0);
        if (cnt > 0) {
            this.pm.update(cnt);
        }
    }

    @Override
    public void update(int completed) {
        if (this.pendingUpdates.getAndAdd(completed) == 0) {
            this.process.release();
        }
    }

    @Override
    public boolean isCancelled() {
        this.lock.lock();
        try {
            boolean bl = this.pm.isCancelled();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void endTask() {
        if (!this.isMainThread()) {
            throw new IllegalStateException();
        }
        this.pm.endTask();
    }

    private boolean isMainThread() {
        return Thread.currentThread() == this.mainThread;
    }
}

