/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.internal.ketch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import zz.org.eclipse.jgit.annotations.Nullable;
import zz.org.eclipse.jgit.internal.ketch.KetchLeader;
import zz.org.eclipse.jgit.internal.ketch.KetchReplica;
import zz.org.eclipse.jgit.internal.ketch.LogIndex;
import zz.org.eclipse.jgit.internal.ketch.ReplicaSnapshot;
import zz.org.eclipse.jgit.lib.ObjectId;

public class LeaderSnapshot {
    final List<ReplicaSnapshot> replicas = new ArrayList<ReplicaSnapshot>();
    KetchLeader.State state;
    long term;
    LogIndex headIndex;
    LogIndex committedIndex;
    boolean idle;

    LeaderSnapshot() {
    }

    public Collection<ReplicaSnapshot> getReplicas() {
        return Collections.unmodifiableList(this.replicas);
    }

    public KetchLeader.State getState() {
        return this.state;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public long getTerm() {
        return this.term;
    }

    @Nullable
    public LogIndex getHead() {
        return this.headIndex;
    }

    @Nullable
    public LogIndex getCommitted() {
        return this.committedIndex;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.isIdle() ? "IDLE" : "RUNNING");
        s.append(" state ").append((Object)this.getState());
        if (this.getTerm() > 0L) {
            s.append(" term ").append(this.getTerm());
        }
        s.append('\n');
        s.append(String.format("%-10s %12s %12s\n", "Replica", "Accepted", "Committed"));
        s.append("------------------------------------\n");
        LeaderSnapshot.debug(s, "(leader)", this.getHead(), this.getCommitted());
        s.append('\n');
        for (ReplicaSnapshot r : this.getReplicas()) {
            LeaderSnapshot.debug(s, r);
            s.append('\n');
        }
        s.append('\n');
        return s.toString();
    }

    private static void debug(StringBuilder b, ReplicaSnapshot s) {
        String err;
        KetchReplica replica = s.getReplica();
        LeaderSnapshot.debug(b, replica.getName(), s.getAccepted(), s.getCommitted());
        b.append(String.format(" %-8s %s", new Object[]{replica.getParticipation(), s.getState()}));
        if (s.getState() == KetchReplica.State.OFFLINE && (err = s.getErrorMessage()) != null) {
            b.append(" (").append(err).append(')');
        }
    }

    private static void debug(StringBuilder s, String name, ObjectId accepted, ObjectId committed) {
        s.append(String.format("%-10s %-12s %-12s", name, LeaderSnapshot.str(accepted), LeaderSnapshot.str(committed)));
    }

    static String str(ObjectId c) {
        if (c instanceof LogIndex) {
            return ((LogIndex)c).describeForLog();
        }
        if (c != null) {
            return c.abbreviate(8).name();
        }
        return "-";
    }
}

