/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.parsers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.networknt.schema.ValidationMessage;
import zz.org.apache.commons.io.FileUtils;
import zz.org.apache.commons.io.IOUtils;
import zz.org.cyclonedx.CycloneDxSchema;
import zz.org.cyclonedx.exception.ParseException;
import zz.org.cyclonedx.model.Bom;
import zz.org.cyclonedx.parsers.Parser;

public class JsonParser
extends CycloneDxSchema
implements Parser {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public Bom parse(File file) throws ParseException {
        try {
            return this.mapper.readValue(file, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException("Unable to parse BOM from File", e);
        }
    }

    @Override
    public Bom parse(byte[] bomBytes) throws ParseException {
        try {
            return this.mapper.readValue(bomBytes, Bom.class);
        }
        catch (IOException | RuntimeException e) {
            throw new ParseException("Unable to parse BOM from byte array", e);
        }
    }

    @Override
    public Bom parse(InputStream inputStream) throws ParseException {
        try {
            return this.mapper.readValue(inputStream, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException("Unable to parse BOM from InputStream", e);
        }
    }

    @Override
    public Bom parse(Reader reader) throws ParseException {
        try {
            return this.mapper.readValue(reader, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException("Unable to parse BOM from Reader", e);
        }
    }

    @Override
    public List<ParseException> validate(File file) throws IOException {
        return this.validate(file, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(File file, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(FileUtils.readFileToString(file, StandardCharsets.UTF_8), schemaVersion, false);
    }

    public List<ParseException> validate(File file, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(FileUtils.readFileToString(file, StandardCharsets.UTF_8), schemaVersion, strict);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(new String(bomBytes), schemaVersion, false);
    }

    public List<ParseException> validate(byte[] bomBytes, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(new String(bomBytes), schemaVersion, strict);
    }

    @Override
    public List<ParseException> validate(Reader reader) throws IOException {
        return this.validate(reader, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(Reader reader, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(IOUtils.toString(reader), schemaVersion, false);
    }

    public List<ParseException> validate(Reader reader, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(IOUtils.toString(reader), schemaVersion, strict);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream) throws IOException {
        return this.validate(inputStream, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(IOUtils.toString(inputStream, StandardCharsets.UTF_8), schemaVersion, false);
    }

    public List<ParseException> validate(InputStream inputStream, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(IOUtils.toString(inputStream, StandardCharsets.UTF_8), schemaVersion, strict);
    }

    public List<ParseException> validate(String bomString, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        JsonReader reader = Json.createReader((Reader)new StringReader(bomString));
        return this.validate(reader.readObject(), schemaVersion, strict);
    }

    public List<ParseException> validate(JsonObject bomJson, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        ArrayList<ParseException> exceptions = new ArrayList<ParseException>();
        Set errors = this.getJsonSchema(schemaVersion, strict, this.mapper).validate(this.mapper.readTree(bomJson.toString()));
        for (ValidationMessage message : errors) {
            exceptions.add(new ParseException(message.getMessage()));
        }
        return exceptions;
    }

    @Override
    public boolean isValid(File file) throws IOException {
        return this.validate(file).isEmpty();
    }

    @Override
    public boolean isValid(File file, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(file, schemaVersion).isEmpty();
    }

    public boolean isValid(File file, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(file, schemaVersion, strict).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(bomBytes, schemaVersion).isEmpty();
    }

    public boolean isValid(byte[] bomBytes, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(bomBytes, schemaVersion, strict).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader) throws IOException {
        return this.validate(reader).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(reader, schemaVersion).isEmpty();
    }

    public boolean isValid(Reader reader, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(reader, schemaVersion, strict).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream) throws IOException {
        return this.validate(inputStream).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(inputStream, schemaVersion).isEmpty();
    }

    public boolean isValid(InputStream inputStream, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(inputStream, schemaVersion, strict).isEmpty();
    }
}

