/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.model.vulnerability;

import java.io.Serializable;
import java.util.List;
import zz.com.fasterxml.jackson.annotation.JsonProperty;
import zz.com.fasterxml.jackson.annotation.JsonRootName;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import zz.org.cyclonedx.model.ExtensibleType;
import zz.org.cyclonedx.model.Source;
import zz.org.cyclonedx.model.vulnerability.Rating;

@JsonRootName(value="vulnerability")
public class Vulnerability10
extends ExtensibleType
implements Serializable {
    public static final String NAMESPACE_URI = "http://cyclonedx.org/schema/ext/vulnerability/1.0";
    public static final String PREFIX = "v";
    public static final String NAME = "vulnerability";
    public static final String ID = "id";
    public static final String SOURCE = "source";
    public static final String SOURCE_NAME = "name";
    public static final String URL = "url";
    public static final String VULNERABILITIES = "vulnerabilities";
    public static final String RATINGS = "ratings";
    public static final String RATING = "rating";
    public static final String REF = "ref";
    public static final String CWES = "cwes";
    public static final String CWE = "cwe";
    public static final String DESCRIPTION = "description";
    public static final String ADVISORIES = "advisories";
    public static final String ADVISORY = "advisory";
    public static final String RECOMMENDATIONS = "recommendations";
    public static final String RECOMMENDATION = "recommendation";
    public static final String SCORE = "score";
    public static final String BASE = "base";
    public static final String IMPACT = "impact";
    public static final String EXPLOITABILITY = "exploitability";
    public static final String SEVERITY = "severity";
    public static final String METHOD = "method";
    public static final String VECTOR = "vector";
    private String id;
    @JsonProperty(value="ref")
    private String ref;
    private Source source;
    private List<Rating> ratings;
    private List<Cwe> cwes;
    private String description;
    private List<Recommendation> recommendations;
    private List<Advisory> advisories;

    public Vulnerability10() {
        super(PREFIX, NAME);
    }

    public Vulnerability10(String namespace, String name) {
        super(namespace, name);
    }

    public List<Advisory> getAdvisories() {
        return this.advisories;
    }

    public void setAdvisories(List<Advisory> advisories) {
        this.advisories = advisories;
    }

    public List<Recommendation> getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(List<Recommendation> recommendations) {
        this.recommendations = recommendations;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Cwe> getCwes() {
        return this.cwes;
    }

    public void setCwes(List<Cwe> cwes) {
        this.cwes = cwes;
    }

    @JacksonXmlElementWrapper(localName="ratings")
    @JacksonXmlProperty(localName="rating")
    public List<Rating> getRatings() {
        return this.ratings;
    }

    public void setRatings(List<Rating> ratings) {
        this.ratings = ratings;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static class Recommendation
    implements Comparable<Recommendation> {
        private String text;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public int compareTo(Recommendation r) {
            return this.text.compareTo(r.getText());
        }
    }

    public static class Advisory {
        private String text;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    public static class Cwe {
        private Integer text;

        public Integer getText() {
            return this.text;
        }

        public void setText(Integer text) {
            this.text = text;
        }
    }

    public static class Score {
        private Double base;
        private Double impact;
        private Double exploitability;

        public Double getBase() {
            return this.base;
        }

        public void setBase(Double base) {
            this.base = base;
        }

        public Double getImpact() {
            return this.impact;
        }

        public void setImpact(Double impact) {
            this.impact = impact;
        }

        public Double getExploitability() {
            return this.exploitability;
        }

        public void setExploitability(Double exploitability) {
            this.exploitability = exploitability;
        }
    }

    public static enum ScoreSource {
        CVSSv3("CVSSv3"),
        CVSSv2("CVSSv2"),
        OWASP("OWASP Risk"),
        FAIR("Open FAIR"),
        OTHER("Other");

        private final String name;

        public String getScoreSourceName() {
            return this.name;
        }

        private ScoreSource(String name) {
            this.name = name;
        }

        public static ScoreSource fromString(String text) {
            for (ScoreSource s : ScoreSource.values()) {
                if (!s.name.equals(text)) continue;
                return s;
            }
            return null;
        }
    }

    public static enum Severity {
        NONE("None"),
        LOW("Low"),
        MEDIUM("Medium"),
        HIGH("High"),
        CRITICAL("Critical"),
        UNKNOWN("Unknown");

        private final String name;

        public String getSeverityName() {
            return this.name;
        }

        private Severity(String name) {
            this.name = name;
        }

        public static Severity fromString(String text) {
            for (Severity s : Severity.values()) {
                if (!s.name.equals(text)) continue;
                return s;
            }
            return null;
        }
    }
}

