/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import zz.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import zz.org.cyclonedx.model.Hash;
import zz.org.cyclonedx.model.VersionFilter;
import zz.org.cyclonedx.util.ExternalReferenceSerializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSerialize(using=ExternalReferenceSerializer.class)
@JsonPropertyOrder(value={"url", "comment", "hashes"})
public class ExternalReference {
    private String url;
    @JacksonXmlProperty(localName="type", isAttribute=true)
    private Type type;
    private String comment;
    @VersionFilter(versions={"1.3"})
    private List<Hash> hashes;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @JacksonXmlElementWrapper(localName="hashes")
    @JacksonXmlProperty(localName="hash")
    public List<Hash> getHashes() {
        return this.hashes;
    }

    public void setHashes(List<Hash> hashes) {
        this.hashes = hashes;
    }

    public void addHash(Hash hash) {
        if (this.hashes == null) {
            this.hashes = new ArrayList<Hash>();
        }
        this.hashes.add(hash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalReference)) {
            return false;
        }
        ExternalReference reference = (ExternalReference)o;
        return Objects.equals(this.url, reference.url) && this.type == reference.type && Objects.equals(this.comment, reference.comment) && Objects.equals(this.hashes, reference.hashes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.type, this.comment, this.hashes});
    }

    public static enum Type {
        VCS("vcs"),
        ISSUE_TRACKER("issue-tracker"),
        WEBSITE("website"),
        ADVISORIES("advisories"),
        BOM("bom"),
        MAILING_LIST("mailing-list"),
        SOCIAL("social"),
        CHAT("chat"),
        DOCUMENTATION("documentation"),
        SUPPORT("support"),
        DISTRIBUTION("distribution"),
        LICENSE("license"),
        BUILD_META("build-meta"),
        BUILD_SYSTEM("build-system"),
        OTHER("other");

        private final String name;

        public String getTypeName() {
            return this.name;
        }

        private Type(String name) {
            this.name = name;
        }
    }
}

