/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.io;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.io.DecoratingInputStream;
import zz.de.schlichtherle.truezip.io.InputClosedException;

@NotThreadSafe
public abstract class DisconnectingInputStream
extends DecoratingInputStream {
    protected DisconnectingInputStream(@Nullable InputStream in) {
        super(in);
    }

    public abstract boolean isOpen();

    protected final void checkOpen() throws InputClosedException {
        if (!this.isOpen()) {
            throw new InputClosedException();
        }
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkOpen();
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.checkOpen();
        return this.delegate.available();
    }

    @Override
    public void mark(int readlimit) {
        if (this.isOpen()) {
            this.delegate.mark(readlimit);
        }
    }

    @Override
    public void reset() throws IOException {
        this.checkOpen();
        this.delegate.reset();
    }

    @Override
    public abstract void close() throws IOException;
}

