/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file.swing;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import zz.de.schlichtherle.truezip.file.TFile;

public final class TFileTreeModel
implements TreeModel {
    private final Map<TFile, TFile[]> cache = new HashMap<TFile, TFile[]>();
    @CheckForNull
    private final TFile root;
    @CheckForNull
    private final FileFilter filter;
    private final Comparator<? super TFile> comparator;
    private final EventListenerList listeners = new EventListenerList();

    public TFileTreeModel(@CheckForNull TFile root, @CheckForNull FileFilter filter, Comparator<? super TFile> comparator) {
        if (null != root && 0 != comparator.compare(root, root)) {
            throw new IllegalArgumentException();
        }
        if (null == comparator) {
            throw new NullPointerException();
        }
        this.root = root;
        this.filter = filter;
        this.comparator = comparator;
    }

    @Override
    public TFile getRoot() {
        return this.root;
    }

    @Override
    public TFile getChild(Object parent, int index) {
        return this.getChildren((TFile)parent)[index];
    }

    @Override
    public int getChildCount(Object parent) {
        TFile[] children = this.getChildren((TFile)parent);
        return null == children ? 0 : children.length;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !((TFile)node).isDirectory();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        TFile[] children = this.getChildren((TFile)parent);
        if (null == children) {
            return -1;
        }
        int l = children.length;
        for (int i = 0; i < l; ++i) {
            if (!children[i].equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private TFile[] getChildren(TFile parent) {
        assert (parent != null);
        TFile[] children = this.cache.get(parent);
        if (null == children) {
            if (this.cache.containsKey(parent)) {
                return null;
            }
            children = parent.listFiles(this.filter);
            this.cache.put(parent, children);
            if (null != children) {
                Arrays.sort(children, this.comparator);
            }
        }
        return children;
    }

    @Nullable
    TreePath newTreePath(TFile node) {
        Object[] elements = this.newPath(node);
        return null == elements ? null : new TreePath(elements);
    }

    @Nullable
    private TFile[] newPath(TFile node) {
        if (null == this.root) {
            return null;
        }
        return this.newPath(node, 1);
    }

    @Nullable
    private TFile[] newPath(@CheckForNull TFile node, int level) {
        TFile[] path;
        assert (this.root != null);
        if (this.root.equals(node)) {
            path = new TFile[level];
            path[0] = this.root;
        } else if (null != node) {
            path = this.newPath(node.getParentFile(), level + 1);
            if (path != null) {
                path[path.length - level] = node;
            }
        } else {
            path = null;
        }
        return path;
    }

    public boolean createNewFile(TFile node) throws IOException {
        if (!node.createNewFile()) {
            return false;
        }
        this.nodeInserted(node);
        return true;
    }

    public void mkdir(TFile node, boolean recursive) throws IOException {
        node.mkdir(recursive);
        this.nodeInserted(node);
    }

    public void cp(@WillClose InputStream in, TFile node) throws IOException {
        TFile.cp(in, (File)node);
        this.nodeInsertedOrStructureChanged(node);
    }

    public void cp(TFile oldNode, TFile node) throws IOException {
        TFile.cp((File)oldNode, (File)node);
        this.nodeInsertedOrStructureChanged(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cp_r(TFile oldNode, TFile node) throws IOException {
        try {
            oldNode.cp_r(node);
        }
        finally {
            this.nodeInsertedOrStructureChanged(node);
        }
    }

    public void cp_p(TFile oldNode, TFile node) throws IOException {
        TFile.cp_p(oldNode, node);
        this.nodeInsertedOrStructureChanged(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cp_rp(TFile oldNode, TFile node) throws IOException {
        try {
            oldNode.cp_rp(node);
        }
        finally {
            this.nodeInsertedOrStructureChanged(node);
        }
    }

    public void mv(TFile oldNode, TFile node) throws IOException {
        oldNode.mv(node);
        this.nodeRemoved(oldNode);
        this.nodeInserted(node);
    }

    public void rm(TFile node) throws IOException {
        TFile.rm(node);
        this.nodeRemoved(node);
    }

    public void rm_r(TFile node) throws IOException {
        TFile.rm_r(node);
        this.nodeRemoved(node);
    }

    public void nodeInsertedOrStructureChanged(TFile node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (this.cache.containsKey(node)) {
            this.structureChanged(node);
        } else {
            this.nodeInserted(node);
        }
    }

    public void nodeInserted(TFile node) {
        if (this.cache.containsKey(node)) {
            return;
        }
        TFile parent = node.getParentFile();
        this.forget(parent, false);
        int index = this.getIndexOfChild(parent, node);
        if (index == -1) {
            return;
        }
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, this.newTreePath(parent), new int[]{index}, (Object[])new TFile[]{node}));
    }

    public void nodeChanged(TFile node) {
        TFile parent = node.getParentFile();
        int index = this.getIndexOfChild(parent, node);
        if (index == -1) {
            return;
        }
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.newTreePath(parent), new int[]{index}, (Object[])new TFile[]{node}));
    }

    public void nodeRemoved(TFile node) {
        TFile parent = node.getParentFile();
        int index = this.getIndexOfChild(parent, node);
        if (index == -1) {
            return;
        }
        this.forget(node, true);
        this.forget(parent, false);
        this.getChildren(parent);
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, this.newTreePath(parent), new int[]{index}, (Object[])new TFile[]{node}));
    }

    public void refresh() {
        this.cache.clear();
        if (this.root != null) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.newTreePath(this.root), null, null));
        }
    }

    public final void refresh(TFile node) {
        this.structureChanged(node);
    }

    public void structureChanged(TFile node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.forget(node, true);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.newTreePath(node), null, null));
    }

    void forget(TFile node) {
        this.forget(node, true);
    }

    private void forget(@Nullable TFile node, boolean childrenToo) {
        TFile[] children = this.cache.remove(node);
        if (null != children && childrenToo) {
            int l = children.length;
            for (int i = 0; i < l; ++i) {
                this.forget(children[i], childrenToo);
            }
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodesChanged(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeNodesChanged(evt);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeNodesInserted(evt);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeNodesRemoved(evt);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeStructureChanged(evt);
        }
    }
}

