/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.file.TBIO;
import zz.de.schlichtherle.truezip.file.TConfig;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.io.DecoratingInputStream;
import zz.de.schlichtherle.truezip.socket.InputSocket;

@Immutable
public final class TFileInputStream
extends DecoratingInputStream {
    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public TFileInputStream(String path) throws FileNotFoundException {
        super(TFileInputStream.newInputStream(new TFile(path)));
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public TFileInputStream(File file) throws FileNotFoundException {
        super(TFileInputStream.newInputStream(file));
    }

    @CreatesObligation
    private static InputStream newInputStream(File src) throws FileNotFoundException {
        InputSocket<?> input = TBIO.getInputSocket(src, TConfig.get().getInputPreferences());
        try {
            return input.newInputStream();
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw (FileNotFoundException)new FileNotFoundException(src.toString()).initCause(ex);
        }
    }
}

