/*
 * Decompiled with CFR 0.152.
 */
package zz.com.neuvector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Random;
import java.util.stream.Stream;
import zz.com.google.gson.Gson;
import zz.com.neuvector.model.Image;
import zz.com.neuvector.model.NVScanner;
import zz.com.neuvector.model.Registry;
import zz.com.neuvector.model.ScanRepoReportData;

public class Scanner {
    private static final String SOCKET_MAPPING = "/var/run/docker.sock:/var/run/docker.sock";
    private static final String CONTAINER_PATH = "/var/neuvector";
    private static final String SCAN_REPORT = "scan_result.json";

    public static ScanRepoReportData scanRegistry(Registry registry, NVScanner nvScanner, String license, Boolean scanLayers) {
        String errorMessage = "";
        if (registry == null || nvScanner == null) {
            errorMessage = "The Registry and nvScanner can't be null.";
        }
        errorMessage = Scanner.pullDockerImage(nvScanner.getNvScannerImage(), nvScanner.getNvRegistryURL(), nvScanner.getNvRegistryUser(), nvScanner.getNvRegistryPassword());
        ScanRepoReportData reportData = null;
        if (errorMessage.length() > 0) {
            reportData = new ScanRepoReportData();
            reportData.setError_message(errorMessage);
        } else {
            String[] credentials = new String[]{registry.getLoginPassword(), license};
            if (scanLayers.booleanValue()) {
                String[] cmdArgs = new String[]{"docker", "run", "--name", Scanner.generateScannerName(), "--rm", "-v", SOCKET_MAPPING, "-v", Scanner.getMountPath(nvScanner), "-e", "SCANNER_REPOSITORY=" + registry.getRepository(), "-e", "SCANNER_TAG=" + registry.getRepositoryTag(), "-e", "SCANNER_LICENSE=" + license, "-e", "SCANNER_REGISTRY=" + registry.getRegistryURL(), "-e", "SCANNER_REGISTRY_USERNAME=" + registry.getLoginUser(), "-e", "SCANNER_REGISTRY_PASSWORD=" + registry.getLoginPassword(), "-e", "SCANNER_SCAN_LAYERS=true", Scanner.getNVImagePath(nvScanner.getNvScannerImage(), nvScanner.getNvRegistryURL())};
                reportData = Scanner.runScan(cmdArgs, nvScanner.getNvMountPath(), credentials);
            } else {
                String[] cmdArgs = new String[]{"docker", "run", "--name", Scanner.generateScannerName(), "--rm", "-v", SOCKET_MAPPING, "-v", Scanner.getMountPath(nvScanner), "-e", "SCANNER_REPOSITORY=" + registry.getRepository(), "-e", "SCANNER_TAG=" + registry.getRepositoryTag(), "-e", "SCANNER_LICENSE=" + license, "-e", "SCANNER_REGISTRY=" + registry.getRegistryURL(), "-e", "SCANNER_REGISTRY_USERNAME=" + registry.getLoginUser(), "-e", "SCANNER_REGISTRY_PASSWORD=" + registry.getLoginPassword(), Scanner.getNVImagePath(nvScanner.getNvScannerImage(), nvScanner.getNvRegistryURL())};
                reportData = Scanner.runScan(cmdArgs, nvScanner.getNvMountPath(), credentials);
            }
        }
        return reportData;
    }

    public static ScanRepoReportData scanRegistry(Registry registry, NVScanner nvScanner, String license) {
        return Scanner.scanRegistry(registry, nvScanner, license, false);
    }

    public static ScanRepoReportData scanLocalImage(Image image, NVScanner nvScanner, String license, Boolean scanLayers) {
        String errorMessage = "";
        if (image == null || nvScanner == null) {
            errorMessage = "The image and nvScanner can't be null.";
        }
        errorMessage = Scanner.pullDockerImage(nvScanner.getNvScannerImage(), nvScanner.getNvRegistryURL(), nvScanner.getNvRegistryUser(), nvScanner.getNvRegistryPassword());
        ScanRepoReportData reportData = null;
        if (errorMessage.length() > 0) {
            reportData = new ScanRepoReportData();
            reportData.setError_message(errorMessage);
        } else {
            String[] credentials = new String[]{license};
            if (scanLayers.booleanValue()) {
                String[] cmdArgs = new String[]{"docker", "run", "--name", Scanner.generateScannerName(), "--rm", "-v", SOCKET_MAPPING, "-v", Scanner.getMountPath(nvScanner), "-e", "SCANNER_REPOSITORY=" + image.getImageName(), "-e", "SCANNER_TAG=" + image.getImageTag(), "-e", "SCANNER_LICENSE=" + license, "-e", "SCANNER_SCAN_LAYERS=true", Scanner.getNVImagePath(nvScanner.getNvScannerImage(), nvScanner.getNvRegistryURL())};
                reportData = Scanner.runScan(cmdArgs, nvScanner.getNvMountPath(), credentials);
            } else {
                String[] cmdArgs = new String[]{"docker", "run", "--name", Scanner.generateScannerName(), "--rm", "-v", SOCKET_MAPPING, "-v", Scanner.getMountPath(nvScanner), "-e", "SCANNER_REPOSITORY=" + image.getImageName(), "-e", "SCANNER_TAG=" + image.getImageTag(), "-e", "SCANNER_LICENSE=" + license, Scanner.getNVImagePath(nvScanner.getNvScannerImage(), nvScanner.getNvRegistryURL())};
                reportData = Scanner.runScan(cmdArgs, nvScanner.getNvMountPath(), credentials);
            }
        }
        return reportData;
    }

    public static ScanRepoReportData scanLocalImage(Image image, NVScanner nvScanner, String license) {
        return Scanner.scanLocalImage(image, nvScanner, license, false);
    }

    private static String pullDockerImage(String nvScannerImage, String nvRegistryURL, String nvRegistryUser, String nvRegistryPassword) {
        if (nvRegistryURL == null) {
            nvRegistryURL = "";
        }
        if (nvRegistryUser == null) {
            nvRegistryUser = "";
        }
        if (nvRegistryPassword == null) {
            nvRegistryPassword = "";
        }
        String errorMessage = "";
        if (nvRegistryURL.isEmpty() && nvRegistryUser.isEmpty() && nvRegistryPassword.isEmpty()) {
            return errorMessage;
        }
        if (nvRegistryUser != "" && nvRegistryPassword != "") {
            String[] cmdArgsDockerLogin = new String[]{"docker", "login", "-u", nvRegistryUser, "-p", nvRegistryPassword, nvRegistryURL};
            errorMessage = Scanner.runCMD(cmdArgsDockerLogin);
            if (errorMessage.length() == 0) {
                String[] cmdArgsDockerPull = new String[]{"docker", "pull", Scanner.getNVImagePath(nvScannerImage, nvRegistryURL)};
                errorMessage = Scanner.runCMD(cmdArgsDockerPull);
                String[] cmdArgsDockerLogout = new String[]{"docker", "logout"};
                errorMessage = Scanner.runCMD(cmdArgsDockerLogout);
            }
        } else {
            String[] cmdArgsDockPull = new String[]{"docker", "pull", Scanner.getNVImagePath(nvScannerImage, nvRegistryURL)};
            errorMessage = Scanner.runCMD(cmdArgsDockPull);
        }
        if (!errorMessage.isEmpty() && !nvRegistryPassword.isEmpty()) {
            errorMessage = Scanner.maskCredential(errorMessage, nvRegistryPassword);
        }
        return errorMessage;
    }

    private static String getNVImagePath(String nvScannerImage, String nvRegistryURL) {
        String nvImagePath = "";
        if (nvRegistryURL.isEmpty()) {
            nvImagePath = nvScannerImage;
        } else {
            nvImagePath = nvRegistryURL.contains("//") ? nvRegistryURL.split("//")[1] : nvRegistryURL;
            nvImagePath = nvRegistryURL.endsWith("/") ? nvImagePath + nvScannerImage : nvImagePath + "/" + nvScannerImage;
        }
        return nvImagePath;
    }

    private static ScanRepoReportData parseScanReport(String scanReportPath) {
        ScanRepoReportData scanReportData;
        StringBuilder contentBuilder = new StringBuilder();
        String errorMessage = null;
        try (Stream<String> stream = Files.lines(Paths.get(scanReportPath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException ex) {
            errorMessage = ex.getMessage();
        }
        if (errorMessage != null) {
            scanReportData = new ScanRepoReportData();
            scanReportData.setError_message(errorMessage);
        } else {
            scanReportData = new Gson().fromJson(contentBuilder.toString(), ScanRepoReportData.class);
        }
        return scanReportData;
    }

    private static String runCMD(String[] cmdArgs) {
        String errorMessage = "";
        try {
            Process process = Runtime.getRuntime().exec(cmdArgs);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String s = null;
            StringBuilder sb = new StringBuilder(String.join((CharSequence)" ", cmdArgs));
            while ((s = stdInput.readLine()) != null) {
                sb.append(s);
            }
            while ((s = stdError.readLine()) != null) {
                sb.append(s);
            }
            if (process.waitFor() != 0) {
                errorMessage = sb.toString();
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        catch (InterruptedException ex) {
            errorMessage = ex.getMessage();
        }
        return errorMessage;
    }

    private static ScanRepoReportData runScan(String[] cmdArgs, String scanReportPath, String[] credentials) {
        String errorMessage = Scanner.runCMD(cmdArgs);
        ScanRepoReportData reportData = null;
        if (errorMessage.length() > 0) {
            for (String credential : credentials) {
                if (credential.isEmpty()) continue;
                errorMessage = Scanner.maskCredential(errorMessage, credential);
            }
            reportData = new ScanRepoReportData();
            reportData.setError_message(errorMessage);
        } else {
            reportData = Scanner.parseScanReport(Scanner.getScanReportPath(scanReportPath));
        }
        return reportData;
    }

    private static String getMountPath(NVScanner nvScanner) {
        String mountPath = ":/var/neuvector";
        String nvPath = nvScanner.getNvMountPath();
        if (nvPath != null && nvPath.length() > 0) {
            if (nvPath.charAt(nvPath.length() - 1) == '/') {
                nvPath = nvPath.substring(0, nvPath.length() - 1);
            }
            mountPath = nvPath + mountPath;
        } else {
            mountPath = CONTAINER_PATH + mountPath;
        }
        return mountPath;
    }

    private static String getScanReportPath(String path) {
        String scanReportPath = "";
        scanReportPath = path == null || path.length() == 0 ? "/var/neuvector/scan_result.json" : Scanner.removeLastSlash(path) + "/" + SCAN_REPORT;
        return scanReportPath;
    }

    private static String removeLastSlash(String str) {
        if (str != null && str.length() > 0 && str.charAt(str.length() - 1) == '/') {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static String generateScannerName() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 6) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }

    private static String maskCredential(String message, String credential) {
        return message.replace(credential, "******");
    }

    public static String deleteDockerImagesByLabelKey(String label) {
        String errorMessage = "";
        String[] cmdArgsDockerDelete = new String[]{"docker", "image", "prune", "--force", "--filter=label=".concat(label)};
        errorMessage = Scanner.runCMD(cmdArgsDockerDelete);
        return errorMessage;
    }
}

