/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.repository;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.apache.commons.lang3.StringUtils;

public final class RepositoryUrlFinderUtils {
    private static final Logger log = LoggerFactory.getLogger(RepositoryUrlFinderUtils.class);

    public static String sanitizeUrl(String urlString) {
        return RepositoryUrlFinderUtils.stripDotGitFromUrl(Objects.requireNonNull(RepositoryUrlFinderUtils.stripCredentialsFromUrl(urlString)));
    }

    private static String stripDotGitFromUrl(String urlString) {
        RepositoryUrlFinderUtils.throwExceptionIfBlank(urlString);
        if (urlString.startsWith("http") && urlString.endsWith(".git")) {
            return urlString.substring(0, urlString.length() - 4);
        }
        return urlString;
    }

    private static String stripCredentialsFromUrl(String urlString) {
        RepositoryUrlFinderUtils.throwExceptionIfBlank(urlString);
        if (urlString.startsWith("http") || urlString.startsWith("ssh")) {
            try {
                URI uri = new URI(urlString);
                urlString = urlString.replace(String.valueOf(uri.getUserInfo()) + "@", "");
            }
            catch (URISyntaxException e) {
                log.debug("url '{}' is not properly formatted", (Object)urlString, (Object)e);
            }
        }
        return urlString;
    }

    private static void throwExceptionIfBlank(String urlString) {
        if (StringUtils.isBlank(urlString)) {
            throw new IllegalArgumentException("url must not be blank");
        }
    }
}

