/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.repository;

import com.sonatype.nexus.git.utils.Environment;
import com.sonatype.nexus.git.utils.repository.AggregateRepositoryUrlFinder;
import com.sonatype.nexus.git.utils.repository.EnvironmentVariableRepositoryUrlFinder;
import com.sonatype.nexus.git.utils.repository.JGitRepositoryUrlFinder;
import com.sonatype.nexus.git.utils.repository.RepositoryUrlFinder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import zz.org.apache.commons.lang3.StringUtils;

public class RepositoryUrlFinderBuilder {
    final Environment environment = new Environment();
    final List<RepositoryUrlFinder> finders = new LinkedList<RepositoryUrlFinder>();
    String fallback;
    Logger logger;

    public RepositoryUrlFinderBuilder withEnvironmentVariableDefault() {
        this.finders.add(new EnvironmentVariableRepositoryUrlFinder(this.environment));
        return this;
    }

    public RepositoryUrlFinderBuilder withEnvironmentVariableNamed(String variableName) {
        this.finders.add(new EnvironmentVariableRepositoryUrlFinder(this.environment, variableName));
        return this;
    }

    public RepositoryUrlFinderBuilder withGitRepo() {
        this.finders.add(new JGitRepositoryUrlFinder());
        return this;
    }

    public RepositoryUrlFinderBuilder withGitRepoAtPath(String path) {
        this.finders.add(new JGitRepositoryUrlFinder(path));
        return this;
    }

    public RepositoryUrlFinderBuilder withFallBack(String fallbackRepositoryUrl) {
        this.fallback = fallbackRepositoryUrl;
        return this;
    }

    public RepositoryUrlFinder build() {
        if (StringUtils.isBlank(this.fallback) && this.finders.size() == 1) {
            return this.finders.get(0);
        }
        return new AggregateRepositoryUrlFinder(this.fallback, this.logger, this.finders.toArray(new RepositoryUrlFinder[0]));
    }

    public RepositoryUrlFinderBuilder withEnvironmentOverride(Map<String, String> environmentOverride) {
        this.environment.addEnvironmentOverrides(environmentOverride);
        return this;
    }

    public RepositoryUrlFinderBuilder withLogger(Logger logger) {
        this.logger = logger;
        return this;
    }
}

