/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.repository;

import com.sonatype.nexus.git.utils.Environment;
import com.sonatype.nexus.git.utils.repository.RepositoryUrlFinder;
import com.sonatype.nexus.git.utils.repository.RepositoryUrlFinderUtils;
import java.util.Optional;
import zz.org.apache.commons.lang3.StringUtils;

public class EnvironmentVariableRepositoryUrlFinder
implements RepositoryUrlFinder {
    static final String DEFAULT_ENV_VARIABLE = "GIT_URL";
    private final Environment environment;
    private final String envVariable;

    EnvironmentVariableRepositoryUrlFinder(Environment environment) {
        this(environment, DEFAULT_ENV_VARIABLE);
    }

    EnvironmentVariableRepositoryUrlFinder(Environment environment, String environmentVariableName) {
        this.environment = environment;
        this.envVariable = environmentVariableName;
    }

    @Override
    public Optional<String> tryGetRepositoryUrl() {
        return Optional.ofNullable(this.getEnvVariable(this.envVariable));
    }

    @Override
    public String getDescription() {
        return "environment variable " + this.envVariable;
    }

    private String getEnvVariable(String name) {
        String value = this.environment.getVariable(name);
        if (StringUtils.isBlank(value)) {
            return null;
        }
        return RepositoryUrlFinderUtils.sanitizeUrl(value);
    }
}

