/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils;

import com.sonatype.clm.dto.model.component.ComponentDisplayName;
import com.sonatype.clm.dto.model.component.ComponentDisplayNameUtil;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import zz.org.apache.commons.lang3.ArrayUtils;
import zz.org.apache.commons.lang3.ClassUtils;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.apache.commons.lang3.Validate;

public class VersionRemediationTitleGenerator {
    private static final String DELIM = "/";
    private static final String REMEDIATION_DELIM = "-to-";
    static final String[] BANNED = ArrayUtils.toArray("?", "*", "\\", "~", "^", ":", "@{", "[", "..", "//", ".lock", "./");
    private static final String[] REPLACEMENTS = new String[BANNED.length];
    private final int maxPartLength;
    private final int maxTotalLength;

    static {
        Arrays.fill(REPLACEMENTS, "");
    }

    public VersionRemediationTitleGenerator() {
        this(50, 243);
    }

    public VersionRemediationTitleGenerator(int maxPartLength, int maxTotalLength) {
        this.maxPartLength = maxPartLength;
        this.maxTotalLength = maxTotalLength;
    }

    public String generateBranchNameForVersionRemediation(String prefix, ComponentIdentifier from, String version) {
        Validate.notNull(from, "ComponentIdentifier is required", new Object[0]);
        from.validate();
        Validate.notEmpty(version, "Version is required", new Object[0]);
        ArrayList<String> namedParts = new ArrayList<String>();
        if (!StringUtils.isEmpty(prefix)) {
            namedParts.add(this.sanitize(prefix));
        }
        ComponentDisplayName componentDisplayName = ComponentDisplayNameUtil.fromIdentifier(from);
        namedParts.addAll(componentDisplayName.parts.stream().filter(part -> part.field != null).map(part -> this.sanitize(part.value)).collect(Collectors.toList()));
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtils.join(namedParts, DELIM)).append(REMEDIATION_DELIM).append(this.sanitize(version));
        return StringUtils.abbreviate(builder.toString(), "_", this.maxTotalLength);
    }

    public int getMaxTotalLength() {
        return this.maxTotalLength;
    }

    private String sanitize(String source) {
        return ClassUtils.getAbbreviatedName(StringUtils.trim(StringUtils.removeEnd(StringUtils.removeStart(StringUtils.replaceEach(this.removeControlCharacters(source), BANNED, REPLACEMENTS), DELIM), DELIM)), this.maxPartLength);
    }

    private String removeControlCharacters(String source) {
        return source.codePoints().filter(c -> c >= 32 && c != 127).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

