/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.ArrayList;
import java.util.List;

public final class PythonDependency {
    static final String[] VERSION_OPERATORS = new String[]{"===", "~=", "==", "!=", "<=", ">=", "<", ">"};
    public String name;
    public String operator;
    public String version;
    public List<String> extras = new ArrayList<String>();

    public static PythonDependency fromString(String dependencyString) {
        int extrasAt;
        PythonDependency dependency = new PythonDependency();
        int minOperatorAt = Integer.MAX_VALUE;
        for (String operator : VERSION_OPERATORS) {
            int operatorAt = dependencyString.indexOf(operator);
            if (operatorAt <= 0 || operatorAt >= minOperatorAt) continue;
            dependency.name = dependencyString.substring(0, operatorAt).trim();
            dependency.operator = operator;
            dependency.version = dependencyString.substring(operatorAt + operator.length()).trim();
            minOperatorAt = operatorAt;
        }
        if (dependency.name == null) {
            if (dependencyString.contains("@")) {
                return null;
            }
            dependency.name = dependencyString;
        }
        if ((extrasAt = dependency.name.indexOf("[")) > 0) {
            String extrasString = dependency.name.substring(extrasAt + 1);
            dependency.name = dependency.name.substring(0, extrasAt).trim();
            if (extrasString.endsWith("]")) {
                String[] extras;
                extrasString = extrasString.substring(0, extrasString.length() - 1);
                for (String extra : extras = extrasString.split(",")) {
                    dependency.extras.add(extra.trim());
                }
            }
        }
        return dependency;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.name != null) {
            result.append(this.name);
            if (!this.extras.isEmpty()) {
                result.append('[');
                result.append(this.extras.get(0));
                for (int i = 1; i < this.extras.size(); ++i) {
                    result.append(',').append(this.extras.get(i));
                }
                result.append(']');
            }
            if (this.operator != null && this.version != null) {
                result.append(this.operator).append(this.version);
            }
        }
        return result.toString();
    }
}

