/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DrupalDependency {
    private static final Pattern NAME_VERSION_PATTERN = Pattern.compile("(?<description>.*)\\((?<name>((\\S+)))\\),(?<version>(\\S+))");
    private final String description;
    private final String name;
    private final String version;

    private DrupalDependency(String description, String name, String version) {
        this.description = description;
        this.name = name;
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public static DrupalDependency fromContent(String content) {
        Matcher matcher = NAME_VERSION_PATTERN.matcher(content);
        if (matcher.find()) {
            return new DrupalDependency(matcher.group("description").trim(), matcher.group("name").trim(), matcher.group("version").trim());
        }
        return null;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof DrupalDependency)) {
            return false;
        }
        DrupalDependency otherDrupalDependency = (DrupalDependency)otherObject;
        return Objects.equals(this.name, otherDrupalDependency.name) && Objects.equals(this.version, otherDrupalDependency.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.description.isEmpty()) {
            sb.append(this.description).append(" ");
        }
        sb.append("(").append(this.name).append("),").append(this.version);
        return sb.toString();
    }
}

