/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.Objects;
import java.util.regex.Pattern;

public final class ConanDependency {
    public String name;
    public String version;
    public String owner;
    public String channel;
    private static final Pattern NAME_VERSION_PATTERN = Pattern.compile("^[a-zA-Z0-9_][a-zA-Z0-9_\\+\\.-]{1,50}\\/[a-zA-Z0-9_][a-zA-Z0-9_\\+\\.-]{1,50}$");

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConanDependency that = (ConanDependency)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.owner, that.owner) && Objects.equals(this.channel, that.channel);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.owner, this.channel);
    }

    public static ConanDependency fromDependencyData(String name, String version, String owner, String channel) {
        return new ConanDependency(name, version, owner, channel);
    }

    ConanDependency(String name, String version, String owner, String channel) {
        this.name = name;
        this.version = version;
        this.owner = owner;
        this.channel = channel;
    }

    public String getConanDependencyString() {
        StringBuilder builder = new StringBuilder(this.name);
        if (this.version != null) {
            builder.append("/").append(this.version);
        }
        if (this.owner != null) {
            builder.append("@").append(this.owner);
            if (this.channel != null) {
                builder.append("/").append(this.channel);
            }
        }
        return builder.toString();
    }

    public static ConanDependency fromString(String line) {
        String[] parts = line.split("@");
        String nameAndVersion = ConanDependency.getElementSafely(parts, 0);
        String ownerAndChannel = ConanDependency.getElementSafely(parts, 1);
        if (nameAndVersion != null && NAME_VERSION_PATTERN.matcher(nameAndVersion).matches()) {
            String[] versionAndBuildNumber;
            String owner = null;
            String channel = null;
            String[] nameVersionSplit = nameAndVersion.trim().split("/");
            String name = ConanDependency.getElementSafely(nameVersionSplit, 0);
            String version = ConanDependency.getElementSafely(nameVersionSplit, 1);
            if (version != null && (versionAndBuildNumber = version.split("\\+")).length > 1) {
                version = ConanDependency.getElementSafely(versionAndBuildNumber, 0);
            }
            if (ownerAndChannel != null) {
                String[] ownerAndChannelSplit = ownerAndChannel.trim().split("/");
                owner = ConanDependency.getElementSafely(ownerAndChannelSplit, 0);
                channel = ConanDependency.getElementSafely(ownerAndChannelSplit, 1);
            }
            if (name != null && version != null) {
                return new ConanDependency(name, version, owner, channel);
            }
        }
        return null;
    }

    private static String getElementSafely(String[] array, int index) {
        try {
            if (array[index] != null) {
                return array[index].trim();
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }
}

