/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CocoaPodsDependency {
    private static final Pattern DEPENDENCY_WITH_VERSION_PATTERN = Pattern.compile("^(.*?)(\\s\\()(=\\s)?(\\S+\\))([:]?)$");
    private final String name;
    private final String version;
    private final int indentLevel;
    private final boolean hasSubDependencies;
    private final boolean hasEqualVersion;

    private CocoaPodsDependency(String name, String version, int indentLevel, boolean hasSubDependencies, boolean hasEqualVersion) {
        this.name = name;
        this.version = version;
        this.indentLevel = indentLevel;
        this.hasSubDependencies = hasSubDependencies;
        this.hasEqualVersion = hasEqualVersion;
    }

    public static CocoaPodsDependency fromString(String line) {
        boolean hasEqualVersion = false;
        Matcher matcher = DEPENDENCY_WITH_VERSION_PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        int spaces = line.substring(0, line.indexOf("-")).length();
        boolean hasSubDependencies = line.charAt(line.length() - 1) == ':';
        String specAndSubSpec = line.substring(0, line.indexOf("(")).replaceFirst("-", "").trim();
        String[] parts = specAndSubSpec.split("/");
        String name = parts.length == 2 ? parts[1] : parts[0];
        String version = line.substring(line.indexOf("(") + 1, line.indexOf(")"));
        if (version.startsWith("= ")) {
            version = version.substring(2);
            hasEqualVersion = true;
        }
        return new CocoaPodsDependency(name, version, spaces, hasSubDependencies, hasEqualVersion);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof CocoaPodsDependency)) {
            return false;
        }
        CocoaPodsDependency otherCocoaPodsDependency = (CocoaPodsDependency)otherObject;
        return Objects.equals(this.name, otherCocoaPodsDependency.name) && Objects.equals(this.version, otherCocoaPodsDependency.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indentLevel; ++i) {
            sb.append(" ");
        }
        sb.append("- ").append(this.name).append(" (");
        if (this.hasEqualVersion) {
            sb.append("= ");
        }
        sb.append(this.version).append(")");
        if (this.hasSubDependencies) {
            sb.append(":");
        }
        return sb.toString();
    }
}

