/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.ClassFileData;
import com.sonatype.insight.scan.hash.internal.asm.ClassFileDigest;
import com.sonatype.insight.scan.hash.internal.asm.ModuleValueDataComparator;
import java.util.Comparator;

class ModuleValueData
implements ClassFileData {
    static final Comparator<ModuleValueData> COMPARATOR = new ModuleValueDataComparator();
    final String name;
    final int access;
    final String[] modules;
    final String version;

    ModuleValueData(String name, String version, int access) {
        this(name, access, (String[])null, version);
    }

    ModuleValueData(String name, int access, String ... modules) {
        this(name, access, modules, (String)null);
    }

    private ModuleValueData(String name, int access, String[] modules, String version) {
        this.name = name;
        this.access = access;
        this.modules = modules;
        this.version = version;
    }

    @Override
    public void digest(ClassFileDigest digest) {
        digest.putString(this.name);
        digest.putAccess(this.access);
        digest.putStringsSorted(this.modules);
        digest.putString(this.version);
    }
}

