/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.DuplicatesAllowed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

class ListPopulator<T>
implements Iterable<T> {
    private final List<T> items;
    private final Comparator<? super T> comparator;
    private final boolean duplicatesAllowed;

    ListPopulator(Comparator<? super T> comparator) {
        this(new ArrayList(), comparator);
    }

    ListPopulator(List<T> items, Comparator<? super T> comparator) {
        this.items = items;
        this.comparator = comparator;
        this.duplicatesAllowed = comparator != null && comparator.getClass().isAnnotationPresent(DuplicatesAllowed.class);
    }

    public T add(T item) {
        if (this.comparator != null) {
            int insertionIndex = Collections.binarySearch(this.items, item, this.comparator);
            if (insertionIndex < 0 || !this.duplicatesAllowed) {
                insertionIndex = -insertionIndex - 1;
            }
            this.items.add(insertionIndex, item);
        } else {
            this.items.add(item);
        }
        return item;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public int size() {
        return this.items.size();
    }
}

