/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.AbstractYarnLockFileReader;
import com.sonatype.insight.scan.file.NpmManifestFileReader;
import com.sonatype.insight.scan.manifest.NpmDependency;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class YarnLockFileReaderV1
extends AbstractYarnLockFileReader {
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("\"?(?<name>[^\\s\"]*)\"?\\s+\"?(?<specifier>[^\"]*)\"?");
    private final List<String> lines;

    YarnLockFileReaderV1(List<String> lines) {
        this.lines = lines;
    }

    @Override
    void parseDependencyData(Map<String, NpmDependency> npmDependencyByNameSpecifier, Map<String, List<String>> directByNameSpecifier, Set<NpmDependency> dependencies) {
        ListIterator<String> iterator = this.lines.listIterator();
        while (iterator.hasNext()) {
            NpmDependency dependency;
            String line = (String)iterator.next();
            if (!line.contains("@") || !line.endsWith(":") || (dependency = this.parseDependency(line, npmDependencyByNameSpecifier, directByNameSpecifier, iterator)) == null) continue;
            dependencies.add(dependency);
        }
        npmDependencyByNameSpecifier.forEach((key, value) -> value.specifiers.add(key.substring(key.lastIndexOf("@") + 1)));
    }

    private NpmDependency parseDependency(String packageIdLineSource, Map<String, NpmDependency> npmDependencyByNameSpecifier, Map<String, List<String>> directByNameSpecifier, Iterator<String> iterator) {
        int index;
        String packageId = null;
        String packageIdLine = packageIdLineSource;
        String[] nameSpecifiers = packageIdLine.substring(0, packageIdLine.length() - 1).split(",");
        if (nameSpecifiers.length > 1) {
            packageIdLine = nameSpecifiers[0];
        }
        if ((index = packageIdLine.lastIndexOf("@")) > -1) {
            packageId = NpmManifestFileReader.removeQuotes(packageIdLine.substring(0, index));
        }
        if (packageId == null) {
            return null;
        }
        String line = null;
        String version = null;
        while (iterator.hasNext() && !(line = iterator.next().trim()).isEmpty() && !line.endsWith(":")) {
            String[] tokens;
            if (!line.startsWith("version") || (tokens = line.split(" ")).length != 2) continue;
            version = NpmManifestFileReader.removeQuotes(tokens[1].trim());
        }
        if (version == null) {
            return null;
        }
        ArrayList<String> direct = new ArrayList<String>();
        if (line.startsWith("dependencies:")) {
            while (iterator.hasNext() && !(line = iterator.next().trim()).isEmpty() && !line.endsWith(":")) {
                Matcher matcher = DEPENDENCY_PATTERN.matcher(line);
                if (!matcher.find()) continue;
                String nameSpecifier = matcher.group("name") + "@" + matcher.group("specifier");
                direct.add(nameSpecifier);
            }
        }
        NpmDependency npmDependency = new NpmDependency(packageId, version);
        for (String nameSpecifier : nameSpecifiers) {
            npmDependencyByNameSpecifier.put(NpmManifestFileReader.removeQuotes(nameSpecifier.trim()), npmDependency);
            directByNameSpecifier.put(NpmManifestFileReader.removeQuotes(nameSpecifier.trim()), direct);
        }
        return npmDependency;
    }
}

