/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.SbomUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.com.github.packageurl.PackageURLBuilder;
import zz.com.google.gson.Gson;
import zz.com.google.gson.annotations.SerializedName;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.cyclonedx.model.Component;

public class SwiftPackageResolvedProcessor {
    private final Logger log;
    private final Gson gson = new Gson();
    private FileVisitor fileVisitor;

    public SwiftPackageResolvedProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(TFile file) {
        this.log.debug("Processing swift package.resolved file: {}", (Object)file.getAbsolutePath());
        try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(file), StandardCharsets.UTF_8);){
            SwiftPackagesObject result = this.gson.fromJson((Reader)reader, SwiftPackagesObject.class);
            if (result != null && result.swiftResolvedPackages != null) {
                String string = SbomUtils.createSbomXmlString(new ArrayList<Component>(this.createBomComponents(result)));
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Set<Component> createBomComponents(SwiftPackagesObject result) {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        List<SwiftPackage> swiftPackages = result.swiftResolvedPackages.swiftPackages;
        if (swiftPackages != null && !swiftPackages.isEmpty()) {
            for (SwiftPackage swiftPackage : swiftPackages) {
                Component component;
                if (!this.isValidPackage(swiftPackage) || !this.isNotSensitiveContent(swiftPackage) || (component = this.createBasicComponent(swiftPackage)) == null) continue;
                components.add(component);
            }
        }
        return components;
    }

    private Component createBasicComponent(SwiftPackage swiftPackage) {
        Component component = SbomUtils.createLibraryComponent(swiftPackage.repositoryURL.replaceAll("^(.+?)://|(\\.git)|(.+?(?=@))|@", ""), swiftPackage.state.version);
        try {
            PackageURLBuilder packageURLBuilder = PackageURLBuilder.aPackageURL().withType("swift").withName(component.getName()).withVersion(component.getVersion());
            component.setPurl(packageURLBuilder.build().canonicalize());
            return component;
        }
        catch (MalformedPackageURLException e) {
            this.log.debug("Invalid coordinates found in the package.resolved file", (Throwable)e);
            return null;
        }
    }

    private boolean isValidPackage(SwiftPackage swiftPackage) {
        if (swiftPackage == null || swiftPackage.state == null) {
            return false;
        }
        return !StringUtils.isAnyBlank(swiftPackage.state.version, swiftPackage.repositoryURL);
    }

    private boolean isNotSensitiveContent(SwiftPackage swiftPackage) {
        return this.fileVisitor.includeResourceName(swiftPackage.repositoryURL);
    }

    public static final class SwiftPackageState {
        @SerializedName(value="version")
        public String version;
    }

    public static final class SwiftPackage {
        @SerializedName(value="repositoryURL")
        public String repositoryURL;
        @SerializedName(value="state")
        public SwiftPackageState state;
    }

    public static final class SwiftResolvedPackages {
        @SerializedName(value="pins")
        public List<SwiftPackage> swiftPackages;
    }

    public static final class SwiftPackagesObject {
        @SerializedName(value="object")
        public SwiftResolvedPackages swiftResolvedPackages;
    }
}

