/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.archive.TFileUtils;
import com.sonatype.insight.scan.file.Stats;
import com.sonatype.insight.scan.hash.Digester;
import com.sonatype.insight.scan.hash.Hash;
import com.sonatype.insight.scan.hash.HashType;
import com.sonatype.insight.scan.hash.IMatchable;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.util.HashUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TVFS;
import zz.de.schlichtherle.truezip.zip.ZipCryptoException;

class ScanUtils {
    ScanUtils() {
    }

    public static void unmount(TFile file, Logger log, String path) {
        if (file.isArchive()) {
            try {
                TVFS.umount(file);
            }
            catch (IOException e) {
                log.warn("Failed to unmount {}: {}", (Object)path, (Object)e.getMessage());
                log.debug("Errors details", (Throwable)e);
            }
        }
    }

    public static void handleError(Stats stats, Exception e, ScanItem item, String path, Logger log) {
        stats.errorCount.incrementAndGet();
        if (ScanUtils.isCryptoError(e)) {
            log.warn("Skipping encrypted file {}", (Object)path);
            log.debug("Error details:", (Throwable)e);
        } else {
            log.error(e.getMessage());
            log.error("Error details:", (Throwable)e);
        }
        if (item != null) {
            item.setHasError();
        }
    }

    private static boolean isCryptoError(Exception e) {
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (!(t instanceof ZipCryptoException)) continue;
            return true;
        }
        return false;
    }

    public static void setHash(ScanItem item, TFile file, Digester digester, Set<HashType> hashTypes) throws Exception {
        try (InputStream is = TFileUtils.openInputStream(file);){
            MessageDigest sha512MessageDigest = MessageDigest.getInstance("SHA-512");
            DigestInputStream digestInputStream = new DigestInputStream(is, sha512MessageDigest);
            Map<HashType, IMatchable> digests = digester.digest(digestInputStream, file.getName(), hashTypes);
            String sha1 = ScanUtils.toHexString(digests.get((Object)HashType.CONTENT));
            item.setSha1(sha1);
            item.setSha1JA001(ScanUtils.toHexString(digests.get((Object)HashType.BYTECODE)));
            item.setSha1JB001(ScanUtils.toHexString(digests.get((Object)HashType.SIGNATURE)));
            item.setSha1JC001(ScanUtils.toHexString(digests.get((Object)HashType.NOPKG_BYTECODE)));
            item.setSha1JD001(ScanUtils.toHexString(digests.get((Object)HashType.NOPKG_SIGNATURE)));
            item.setSha1KA001(ScanUtils.toHexString(digests.get((Object)HashType.TYPE)));
            item.setSha1KB001(ScanUtils.toHexStrings(digests.get((Object)HashType.FIELD)));
            item.setSha1KC001(ScanUtils.toHexStrings(digests.get((Object)HashType.METHOD_SIGNATURE)));
            item.setSha1KD001(ScanUtils.toHexStrings(digests.get((Object)HashType.METHOD)));
            item.setSha1LA001(ScanUtils.toHexString(digests.get((Object)HashType.NOPKG_TYPE)));
            item.setSha1LB001(ScanUtils.toHexStrings(digests.get((Object)HashType.NOPKG_FIELD)));
            item.setSha1LC001(ScanUtils.toHexStrings(digests.get((Object)HashType.NOPKG_METHOD_SIGNATURE)));
            item.setSha1LD001(ScanUtils.toHexStrings(digests.get((Object)HashType.NOPKG_METHOD)));
            item.setSha512(HashUtils.toHex((byte[])sha512MessageDigest.digest()));
        }
    }

    private static String toHexString(IMatchable hash) {
        return hash != null ? ((Hash)hash).toHexString() : null;
    }

    private static String[] toHexStrings(IMatchable hash) {
        Collection<Hash> hashes;
        String[] result = null;
        if (hash != null && !(hashes = hash.getHashes()).isEmpty()) {
            result = new String[hashes.size()];
            int i = 0;
            for (Hash h : hashes) {
                result[i++] = h.toHexString();
            }
        }
        return result;
    }

    public static String getRelativePath(File file, File basedir) {
        if (file == null) {
            return null;
        }
        if (basedir == null || !file.isAbsolute()) {
            return file.getPath();
        }
        if (!basedir.isAbsolute()) {
            basedir = basedir.getAbsoluteFile();
        }
        String path = "";
        File current = file.getAbsoluteFile();
        while (!basedir.equals(current)) {
            String filename = current.getName();
            if ((current = current.getParentFile()) == null) {
                return null;
            }
            if (path.isEmpty()) {
                path = filename;
                continue;
            }
            path = filename + '/' + path;
        }
        return path;
    }
}

