/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.NpmManifestFileReader;
import com.sonatype.insight.scan.manifest.NpmDependencies;
import com.sonatype.insight.scan.manifest.NpmDependency;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.StringUtils;

public class PnpmLockFileReader
implements NpmManifestFileReader {
    private static final Logger log = LoggerFactory.getLogger(PnpmLockFileReader.class);

    @Override
    public NpmDependencies read(TFile file) {
        LinkedHashSet<NpmDependency> dependencies = new LinkedHashSet<NpmDependency>();
        try {
            JsonNode jsonNode = new ObjectMapper(new YAMLFactory()).readTree(file);
            HashMap<String, NpmDependency> npmDependencyByNameVersion = new HashMap<String, NpmDependency>();
            HashMap<String, List<String>> directByNameVersion = new HashMap<String, List<String>>();
            Iterator<Map.Entry<String, JsonNode>> packageIterator = jsonNode.path("packages").fields();
            while (packageIterator.hasNext()) {
                this.process(npmDependencyByNameVersion, directByNameVersion, packageIterator.next());
            }
            for (Map.Entry entry : npmDependencyByNameVersion.entrySet()) {
                for (String childNameVersion : (List)directByNameVersion.get(entry.getKey())) {
                    NpmDependency child = (NpmDependency)npmDependencyByNameVersion.get(childNameVersion);
                    if (child == null) {
                        log.debug("no dependency details found for specifier {} in manifest {}", (Object)childNameVersion, (Object)file);
                        continue;
                    }
                    ((NpmDependency)entry.getValue()).dependencies.add(child);
                }
            }
            JsonNode dependenciesNode = jsonNode.path("dependencies");
            if (dependenciesNode.isMissingNode()) {
                dependencies.addAll(npmDependencyByNameVersion.values());
            } else {
                Iterator<Map.Entry<String, JsonNode>> dependencyIterator = dependenciesNode.fields();
                while (dependencyIterator.hasNext()) {
                    String[] nameVersion = this.getNameVersion(dependencyIterator.next());
                    if (nameVersion == null) continue;
                    String key = this.getFieldName(nameVersion);
                    NpmDependency npmDependency = (NpmDependency)npmDependencyByNameVersion.get(key);
                    if (npmDependency == null) {
                        log.debug("no dependency details found for specifier {} in manifest {}", (Object)key, (Object)file);
                        continue;
                    }
                    dependencies.add(npmDependency);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        return this.createNpmDependenciesFilteredByPackageJson(file, dependencies);
    }

    private void process(Map<String, NpmDependency> npmDependencyByNameVersion, Map<String, List<String>> directByNameVersion, Map.Entry<String, JsonNode> packageEntry) {
        String[] nameVersion = this.getNameVersion(packageEntry.getKey());
        if (nameVersion == null) {
            return;
        }
        String key = this.getFieldName(nameVersion);
        npmDependencyByNameVersion.computeIfAbsent(key, k -> new NpmDependency(nameVersion[0], nameVersion[1]));
        List directs = directByNameVersion.computeIfAbsent(key, k -> new ArrayList());
        Iterator<Map.Entry<String, JsonNode>> dependencyIterator = packageEntry.getValue().path("dependencies").fields();
        while (dependencyIterator.hasNext()) {
            Map.Entry<String, JsonNode> dependencyEntry = dependencyIterator.next();
            String[] dependencyNameVersion = this.getNameVersion(dependencyEntry);
            if (dependencyNameVersion == null) continue;
            directs.add(this.getFieldName(dependencyNameVersion));
        }
    }

    private String[] getNameVersion(Map.Entry<String, JsonNode> fieldNameAndValue) {
        String packageId = NpmManifestFileReader.removeQuotes(fieldNameAndValue.getKey()).trim();
        if (!fieldNameAndValue.getValue().isTextual()) {
            log.debug("Unable to determine version for dependency {}.", fieldNameAndValue);
            return null;
        }
        String version = this.getVersion(fieldNameAndValue.getValue().asText().trim());
        if (StringUtils.isAnyBlank(packageId, version)) {
            log.debug("Unable to determine packageId and/or version for dependency {}.", fieldNameAndValue);
            return null;
        }
        return new String[]{packageId, version};
    }

    private String[] getNameVersion(String fieldName) {
        String version;
        int packageIdStartIndex = fieldName.startsWith("/") ? 1 : 0;
        int packageIdEndIndex = fieldName.lastIndexOf(47);
        if (packageIdEndIndex == -1 || packageIdEndIndex == fieldName.length() - 1 || packageIdStartIndex >= packageIdEndIndex) {
            log.debug("Unable to determine packageId for package {}.", (Object)fieldName);
            return null;
        }
        String packageId = fieldName.substring(packageIdStartIndex, packageIdEndIndex);
        if (StringUtils.isAnyBlank(packageId, version = this.getVersion(fieldName.substring(packageIdEndIndex + 1)))) {
            log.debug("Unable to determine packageId and/or version for package {}.", (Object)fieldName);
            return null;
        }
        return new String[]{packageId, version};
    }

    private String getVersion(String input) {
        String[] version = input.split("_");
        if (version.length > 0) {
            return version[0];
        }
        return input;
    }

    private String getFieldName(String[] nameVersion) {
        return "/" + nameVersion[0] + "/" + nameVersion[1];
    }
}

