/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.PhpComposerDependencies;
import com.sonatype.insight.scan.manifest.PhpComposerPackage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.slf4j.Logger;
import zz.com.google.gson.Gson;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;

public class PhpComposerProcessor {
    private final Logger log;
    private final Gson gson = new Gson();
    private FileVisitor fileVisitor;

    public PhpComposerProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(TFile file) {
        this.log.debug("Processing composer file: {}", (Object)file.getAbsolutePath());
        try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(file), StandardCharsets.UTF_8);){
            PhpComposerDependencies result = this.gson.fromJson((Reader)reader, PhpComposerDependencies.class);
            this.filterSensitiveContent(result);
            String string = this.gson.toJson(result);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void filterSensitiveContent(PhpComposerDependencies result) {
        if (result.packages != null) {
            Iterator<PhpComposerPackage> it = result.packages.iterator();
            while (it.hasNext()) {
                PhpComposerPackage phpComposerPackage = it.next();
                if (this.fileVisitor.includeResourceName(phpComposerPackage.name)) continue;
                this.log.debug("Not including component '{}'.", (Object)phpComposerPackage.name);
                it.remove();
            }
        }
    }
}

